/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.kernel.util.StringUtil;

public interface ServerEvent {
    default public boolean isValidId() {
        return this.getId() != -1L;
    }

    public long getId();

    public ServerEventName getName();

    default public String subType() {
        return "";
    }

    public String getData(String var1, User var2);

    default public boolean isConcerned(String receiverSessionId, User receiver) {
        return true;
    }

    default public boolean send(SilverpeasServerEventContext context, String receiverSessionId, User receiver) throws IOException {
        if (!this.isConcerned(receiverSessionId, receiver)) {
            return false;
        }
        String eventName = StringUtil.defaultStringIfNotDefined((String)this.getName().asString());
        String eventData = StringUtil.defaultStringIfNotDefined((String)this.getData(receiverSessionId, receiver));
        return context.sendEvent(eventName, this.getId(), eventData);
    }

    @FunctionalInterface
    public static interface ServerEventName {
        public String asString();
    }
}

