/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;

public abstract class AbstractServerEvent
implements ServerEvent {
    private static long idCounter = 0L;
    private long id = -1L;
    private String data = "";
    private BiFunction<String, User, String> dynamicData = null;

    public List<String> getEventSourceURIs() {
        return Collections.emptyList();
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            this.id = AbstractServerEvent.nextId();
        }
        return this.id;
    }

    @Override
    public String getData(String receiverSessionId, User receiver) {
        return this.dynamicData == null ? this.data : this.dynamicData.apply(receiverSessionId, receiver);
    }

    @Override
    public boolean send(SilverpeasServerEventContext context, String receiverSessionId, User receiver) throws IOException {
        List<String> eventSourceURIs = this.getEventSourceURIs();
        boolean aimedEventSource = eventSourceURIs.isEmpty();
        if (!aimedEventSource) {
            for (String eventSourceURI : eventSourceURIs) {
                if (!context.getRequestURI().endsWith(eventSourceURI)) continue;
                aimedEventSource = true;
                break;
            }
        }
        return aimedEventSource && ServerEvent.super.send(context, receiverSessionId, receiver);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("id", this.getId());
        tsb.append("name", (Object)this.getName().asString());
        return tsb.toString();
    }

    protected <T extends AbstractServerEvent> T withData(String data) {
        this.data = data;
        return (T)this;
    }

    protected <T extends AbstractServerEvent> T withData(BiFunction<String, User, String> dynamicData) {
        this.dynamicData = dynamicData;
        return (T)this;
    }

    private static synchronized long nextId() {
        return idCounter++;
    }
}

