/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.util.Date;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WithThumbnail;
import org.silverpeas.core.i18n.ResourceTranslation;

class LocalizedContributionWrapper
implements LocalizedContribution,
WithThumbnail,
WithPermanentLink {
    private final Contribution contribution;
    private final ResourceTranslation translation;

    LocalizedContributionWrapper(Contribution contribution, String language) {
        this.contribution = contribution;
        this.translation = contribution instanceof I18nContribution ? ((I18nContribution)contribution).getTranslation(language) : new TranslationWrapper(language, contribution);
    }

    @Override
    public ContributionIdentifier getIdentifier() {
        return this.contribution.getIdentifier();
    }

    @Override
    public String getTitle() {
        return this.translation.getName();
    }

    @Override
    public String getDescription() {
        return this.translation.getDescription();
    }

    @Override
    public String getContributionType() {
        return this.contribution.getContributionType();
    }

    @Override
    public boolean isIndexable() {
        return this.contribution.isIndexable();
    }

    @Override
    public User getCreator() {
        return this.contribution.getCreator();
    }

    @Override
    public Date getCreationDate() {
        return this.contribution.getCreationDate();
    }

    @Override
    public User getLastUpdater() {
        return this.contribution.getLastUpdater();
    }

    @Override
    public Date getLastUpdateDate() {
        return this.contribution.getLastUpdateDate();
    }

    @Override
    public boolean canBeAccessedBy(User user) {
        return this.contribution.canBeAccessedBy(user);
    }

    @Override
    public String getLanguage() {
        return this.translation.getLanguage();
    }

    @Override
    public String getPermalink() {
        if (this.contribution instanceof WithPermanentLink) {
            return ((WithPermanentLink)((Object)this.contribution)).getPermalink();
        }
        return "";
    }

    @Override
    public Thumbnail getThumbnail() {
        if (this.contribution instanceof WithThumbnail) {
            return ((WithThumbnail)((Object)this.contribution)).getThumbnail();
        }
        return null;
    }

    private static class TranslationWrapper
    implements ResourceTranslation {
        private final String language;
        private final Contribution contribution;

        private TranslationWrapper(String language, Contribution contribution) {
            this.language = language;
            this.contribution = contribution;
        }

        @Override
        public String getId() {
            return this.contribution.getIdentifier().asString();
        }

        @Override
        public String getName() {
            return this.contribution.getName();
        }

        @Override
        public String getDescription() {
            return this.contribution.getDescription();
        }

        @Override
        public String getLanguage() {
            return this.language;
        }
    }
}

