/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.util.MissingResourceException;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

public class ContributionLocalizationBundle {
    private static final String NO_PROPERTY = "CONTRIBUTION_LOCALIZATION_BUNDLED#NO_PROPERTY";
    private final Contribution contribution;
    private final LocalizationBundle mainBundle;
    private final LocalizationBundle componentBundle;

    private ContributionLocalizationBundle(Contribution contribution, LocalizationBundle mainBundle, LocalizationBundle componentBundle) {
        this.contribution = contribution;
        this.mainBundle = mainBundle;
        this.componentBundle = componentBundle;
    }

    public static ContributionLocalizationBundle getByInstanceAndLanguage(Contribution contribution, String language) {
        LocalizationBundle main = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.contribution.multilang.contribution", (String)language);
        String componentName = SilverpeasComponentInstance.getComponentName(contribution.getIdentifier().getComponentInstanceId());
        Optional specific = ResourceLocator.getOptionalLocalizationBundle((String)("org.silverpeas." + componentName.toLowerCase() + ".multilang.contribution"), (String)language);
        return new ContributionLocalizationBundle(contribution, main, specific.orElse(null));
    }

    public String getUiMessageTitleByType() {
        return this.getUiMessageTitleByTypeAndProperty(NO_PROPERTY);
    }

    public String getUiMessageTitleByTypeAndProperty(String property) {
        return this.getByTypeAndPropertyOrJustByType(property, (Pair<String, Object[]>)Pair.of((Object)"ui.message.label", (Object)ArrayUtils.toArray((Object[])new String[]{this.contribution.getTitle()})));
    }

    private String getByTypeAndPropertyOrJustByType(String property, Pair<String, Object[]> keySuffixAndParameters) {
        String contributionType = this.contribution.getIdentifier().getType();
        String keySuffix = (String)keySuffixAndParameters.getLeft();
        Object[] parameters = (Object[])keySuffixAndParameters.getRight();
        String keyBase = "contribution." + contributionType + ".";
        if (!NO_PROPERTY.equals(property)) {
            try {
                return this.getStringWithParams(keyBase + property + "." + keySuffix, parameters);
            }
            catch (MissingResourceException mre) {
                SilverLogger.getLogger((Object)this).silent((Throwable)mre);
            }
        }
        return this.getStringWithParams(keyBase + keySuffix, parameters);
    }

    private String getStringWithParams(String key, Object ... params) {
        if (this.componentBundle != null) {
            try {
                return this.componentBundle.getStringWithParams(key, params);
            }
            catch (MissingResourceException mre) {
                SilverLogger.getLogger((Object)this).silent((Throwable)mre).debug(mre.getMessage(), new Object[0]);
            }
        }
        return this.mainBundle.getStringWithParams(key, params);
    }
}

