/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.view;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.InternalAttendee;
import org.silverpeas.core.calendar.view.CalendarEventView;
import org.silverpeas.core.date.TemporalConverter;

public class CalendarEventInternalParticipationView
implements CalendarEventView<String> {
    private final Set<String> filterOnParticipantIds;

    public CalendarEventInternalParticipationView() {
        this(Collections.emptySet());
    }

    public CalendarEventInternalParticipationView(Collection<User> filterOnParticipants) {
        this.filterOnParticipantIds = filterOnParticipants.stream().map(User::getId).collect(Collectors.toSet());
    }

    @Override
    public Map<String, List<CalendarEventOccurrence>> apply(List<CalendarEventOccurrence> occurrences) {
        HashMap<String, List<CalendarEventOccurrence>> view = new HashMap<String, List<CalendarEventOccurrence>>();
        for (CalendarEventOccurrence occurrence : occurrences) {
            String createdBy = occurrence.getCalendarEvent().getCreator().getId();
            if (this.filterOnParticipantIds.isEmpty() || this.filterOnParticipantIds.contains(createdBy)) {
                this.add(view, createdBy, occurrence);
            }
            occurrence.getAttendees().stream().filter(a -> a instanceof InternalAttendee).filter(a -> this.filterOnParticipantIds.isEmpty() || !a.getId().equals(createdBy) && this.filterOnParticipantIds.contains(a.getId())).filter(a -> Attendee.PresenceStatus.REQUIRED == a.getPresenceStatus() || Attendee.ParticipationStatus.DECLINED != a.getParticipationStatus()).forEach(a -> this.add(view, a.getId(), occurrence));
        }
        view.values().forEach(userOccurrences -> userOccurrences.sort(Comparator.comparing(o -> o.getCalendarEvent().getCalendar().getId()).thenComparing(o -> TemporalConverter.asOffsetDateTime(o.getStartDate()))));
        return view;
    }

    private void add(Map<String, List<CalendarEventOccurrence>> view, String participant, CalendarEventOccurrence occurrence) {
        List occurrences = view.computeIfAbsent(participant, u -> new LinkedList());
        occurrences.add(occurrence);
    }
}

