/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.AttributeConverter;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Converter;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.calendar.DayOfWeekOccurrence;
import org.silverpeas.core.calendar.RecurrencePeriod;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.kernel.util.Pair;

@Entity
@Table(name="sb_cal_recurrence")
public class Recurrence
implements Serializable {
    public static final Recurrence NO_RECURRENCE = null;
    public static final int NO_RECURRENCE_COUNT = 0;
    public static final OffsetDateTime NO_RECURRENCE_END_DATE = null;
    @Id
    private String id;
    @Embedded
    private RecurrencePeriod frequency;
    @Column(name="recur_count")
    private int count = 0;
    @Column(name="recur_endDate")
    private OffsetDateTime endDateTime = NO_RECURRENCE_END_DATE;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="sb_cal_recurrence_dayofweek", joinColumns={@JoinColumn(name="recurrenceId")})
    private Set<DayOfWeekOccurrence> daysOfWeek = new HashSet<DayOfWeekOccurrence>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="sb_cal_recurrence_exception", joinColumns={@JoinColumn(name="recurrenceId")})
    @Column(name="recur_exceptionDate")
    @Convert(converter=ExceptionDateNormalizer.class)
    private Set<OffsetDateTime> exceptionDates = new HashSet<OffsetDateTime>();
    @Transient
    private transient Temporal startDate;

    protected Recurrence() {
    }

    private Recurrence(RecurrencePeriod frequency) {
        this.withFrequency(frequency);
    }

    public static Recurrence every(TimeUnit frequencyUnit) {
        return new Recurrence(RecurrencePeriod.every(1, frequencyUnit));
    }

    public static Recurrence every(int frequencyValue, TimeUnit frequencyUnit) {
        return new Recurrence(RecurrencePeriod.every(frequencyValue, frequencyUnit));
    }

    public static Recurrence from(RecurrencePeriod period) {
        return new Recurrence(period);
    }

    public Recurrence excludeEventOccurrencesStartingAt(Temporal ... temporal) {
        this.exceptionDates.addAll(Arrays.stream(temporal).map(this::normalize).sorted().collect(Collectors.toList()));
        return this;
    }

    public Recurrence on(DayOfWeek ... days) {
        this.checkRecurrenceStateForSpecificDaySetting();
        ArrayList<DayOfWeekOccurrence> dayOccurrences = new ArrayList<DayOfWeekOccurrence>();
        int nth = this.getFrequency().isWeekly() ? 1 : 0;
        for (DayOfWeek dayOfWeek : days) {
            dayOccurrences.add(DayOfWeekOccurrence.nth(nth, dayOfWeek));
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.addAll(dayOccurrences);
        return this;
    }

    public Recurrence on(DayOfWeekOccurrence ... days) {
        return this.on(Arrays.asList(days));
    }

    public Recurrence on(List<DayOfWeekOccurrence> days) {
        this.checkRecurrenceStateForSpecificDaySetting();
        if (this.frequency.getUnit() == TimeUnit.WEEK) {
            for (DayOfWeekOccurrence dayOfWeekOccurrence : days) {
                if (dayOfWeekOccurrence.nth() == 1 || dayOfWeekOccurrence.nth() == 0) continue;
                throw new IllegalArgumentException("The occurrence of the day of week " + dayOfWeekOccurrence.dayOfWeek().name() + " cannot be possible with a weekly recurrence");
            }
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.addAll(days);
        return this;
    }

    public Recurrence onNoSpecificDay() {
        this.daysOfWeek.clear();
        return this;
    }

    public Recurrence until(int recurrenceCount) {
        if (recurrenceCount <= 0) {
            throw new IllegalArgumentException("The number of time the event has to recur should be a positive value");
        }
        this.endDateTime = NO_RECURRENCE_END_DATE;
        this.count = recurrenceCount;
        this.clearsUnnecessaryExceptionDates();
        return this;
    }

    public Recurrence until(Temporal endDate) {
        this.endDateTime = this.normalize(endDate);
        this.count = 0;
        this.clearsUnnecessaryExceptionDates();
        return this;
    }

    public Recurrence endless() {
        this.count = 0;
        this.endDateTime = NO_RECURRENCE_END_DATE;
        return this;
    }

    public Recurrence withFrequency(RecurrencePeriod frequency) {
        this.frequency = frequency;
        if (this.getFrequency().isDaily() || this.getFrequency().isYearly()) {
            this.daysOfWeek.clear();
        }
        return this;
    }

    public boolean isEndless() {
        return !this.getRecurrenceEndDate().isPresent() && this.getRecurrenceCount() == 0;
    }

    public RecurrencePeriod getFrequency() {
        return this.frequency;
    }

    public int getRecurrenceCount() {
        return this.count;
    }

    public Optional<Temporal> getRecurrenceEndDate() {
        if (this.endDateTime != NO_RECURRENCE_END_DATE) {
            return Optional.of(this.getStartDate() instanceof LocalDate ? this.endDateTime.toLocalDate() : this.endDateTime);
        }
        return Optional.empty();
    }

    public Optional<Temporal> getEndDate() {
        if (!this.isEndless()) {
            return Optional.of(this.getRecurrenceEndDate().orElse(this.computeEndDate()));
        }
        return Optional.empty();
    }

    public Temporal getStartDate() {
        if (this.startDate == null) {
            throw new IllegalStateException("The recurrence isn't applied to any recurrent calendar component!");
        }
        return this.startDate;
    }

    public Set<DayOfWeekOccurrence> getDaysOfWeek() {
        return Collections.unmodifiableSet(this.daysOfWeek);
    }

    public Set<Temporal> getExceptionDates() {
        return this.exceptionDates.stream().map(this::decode).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Recurrence)) {
            return false;
        }
        Recurrence that = (Recurrence)o;
        if (this.count != that.count || !this.frequency.equals(that.frequency)) {
            return false;
        }
        if (this.endDateTime != null ? !this.endDateTime.equals(that.endDateTime) : that.endDateTime != null) {
            return false;
        }
        return this.daysOfWeek.equals(that.daysOfWeek) && this.exceptionDates.equals(that.exceptionDates);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.count).append((Object)this.endDateTime).append(this.daysOfWeek).append(this.exceptionDates).toHashCode();
    }

    public Recurrence copy() {
        Recurrence copy = new Recurrence();
        copy.id = null;
        copy.startDate = this.startDate;
        copy.endDateTime = this.endDateTime;
        copy.count = this.count;
        copy.frequency = this.frequency;
        copy.daysOfWeek = new HashSet<DayOfWeekOccurrence>(this.daysOfWeek);
        copy.exceptionDates = new HashSet<OffsetDateTime>(this.exceptionDates);
        return copy;
    }

    boolean sameAs(Recurrence recurrence) {
        if (this.equals(recurrence)) {
            return true;
        }
        if (recurrence == null) {
            return false;
        }
        if (!(recurrence.count == this.count && recurrence.daysOfWeek.equals(this.daysOfWeek) && recurrence.startDate.equals(this.startDate) && this.sameFrequencyAs(recurrence))) {
            return false;
        }
        return this.sameEndTimeAs(recurrence);
    }

    private boolean sameFrequencyAs(Recurrence recurrence) {
        return recurrence.frequency.getUnit() == this.frequency.getUnit() && recurrence.frequency.getInterval() == this.frequency.getInterval();
    }

    private boolean sameEndTimeAs(Recurrence recurrence) {
        return recurrence.endDateTime == NO_RECURRENCE_END_DATE && this.endDateTime == NO_RECURRENCE_END_DATE || recurrence.endDateTime != NO_RECURRENCE_END_DATE && recurrence.endDateTime.equals(this.endDateTime);
    }

    Recurrence startingAt(Temporal date) {
        this.startDate = date;
        if (this.endDateTime != null) {
            this.until(this.endDateTime.toLocalDate());
        }
        if (!this.exceptionDates.isEmpty()) {
            List<Pair> datesToModify = this.exceptionDates.stream().map(t -> Pair.of((Object)t, (Object)this.normalize((Temporal)t))).filter(Predicate.not(p -> ((OffsetDateTime)p.getFirst()).equals(p.getSecond()))).collect(Collectors.toList());
            datesToModify.forEach(p -> {
                this.exceptionDates.remove(p.getFirst());
                this.exceptionDates.add((OffsetDateTime)p.getSecond());
            });
        }
        return this;
    }

    void clearsAllExceptionDates() {
        this.exceptionDates.clear();
    }

    @PrePersist
    protected void generateId() {
        this.id = UUID.randomUUID().toString();
    }

    private void checkRecurrenceStateForSpecificDaySetting() {
        if (this.getFrequency().isDaily()) {
            throw new IllegalStateException("Some specific days cannot be set for a daily recurrence");
        }
    }

    private void clearsUnnecessaryExceptionDates() {
        if (!this.exceptionDates.isEmpty()) {
            this.getEndDate().ifPresent(e -> this.exceptionDates.removeIf(exceptionDate -> TemporalConverter.asOffsetDateTime(e).isBefore((OffsetDateTime)exceptionDate)));
        }
    }

    private OffsetDateTime normalize(Temporal temporal) {
        OffsetDateTime dateTime = TemporalConverter.asOffsetDateTime(temporal).withOffsetSameInstant(ZoneOffset.UTC);
        if (this.startDate != null) {
            return (OffsetDateTime)TemporalConverter.applyByType(this.startDate, TemporalConverter.Conversion.of(LocalDate.class, t -> dateTime.with(LocalTime.MIDNIGHT.atOffset(ZoneOffset.UTC))), TemporalConverter.Conversion.of(OffsetDateTime.class, t -> dateTime.with(t.toOffsetTime())));
        }
        return dateTime;
    }

    private Temporal decode(OffsetDateTime dateTime) {
        return this.getStartDate() instanceof LocalDate ? dateTime.toLocalDate() : dateTime;
    }

    private Temporal computeDateForMonthlyFrequencyFrom(Temporal source, DayOfWeekOccurrence dayOfWeek) {
        Temporal current = source;
        if (dayOfWeek.nth() > 1) {
            current = current.with(ChronoField.ALIGNED_WEEK_OF_MONTH, dayOfWeek.nth());
        } else if (dayOfWeek.nth() < 0) {
            current = current.with(ChronoField.DAY_OF_MONTH, 1L).plus(1L, ChronoUnit.MONTHS).minus(1L, ChronoUnit.DAYS).plus(dayOfWeek.nth(), ChronoUnit.WEEKS).with(dayOfWeek.dayOfWeek());
        }
        return current;
    }

    private Temporal computeDateForYearlyFrequencyFrom(Temporal source, DayOfWeekOccurrence dayOfWeek) {
        int lastDayOfYear = 31;
        Temporal current = source;
        if (dayOfWeek.nth() > 1) {
            current = current.with(ChronoField.ALIGNED_WEEK_OF_YEAR, dayOfWeek.nth());
        } else if (dayOfWeek.nth() < 0) {
            current = current.with(MonthDay.of(Month.DECEMBER, 31)).plus(dayOfWeek.nth(), ChronoUnit.WEEKS).with(dayOfWeek.dayOfWeek());
        }
        return current;
    }

    private Temporal computeEndDate() {
        Temporal date = this.getStartDate();
        if (this.getRecurrenceCount() == 1) {
            return date;
        }
        long interval = (long)this.getRecurrenceCount() * (long)(this.getFrequency().getInterval() >= 1 ? this.getFrequency().getInterval() : 1);
        date = date.plus(interval, this.getFrequency().getUnit().toChronoUnit());
        boolean firstDayOfWeekSet = false;
        for (DayOfWeekOccurrence dayOfWeek : this.daysOfWeek) {
            Temporal current = date.with(dayOfWeek.dayOfWeek());
            if (this.getFrequency().isMonthly()) {
                current = this.computeDateForMonthlyFrequencyFrom(current, dayOfWeek);
            } else if (this.getFrequency().isYearly()) {
                current = this.computeDateForYearlyFrequencyFrom(current, dayOfWeek);
            }
            if (firstDayOfWeekSet && !LocalDate.from(current).isAfter(LocalDate.from(date))) continue;
            date = current;
            firstDayOfWeekSet = true;
        }
        return date;
    }

    @Converter
    public static class ExceptionDateNormalizer
    implements AttributeConverter<OffsetDateTime, Timestamp> {
        public Timestamp convertToDatabaseColumn(OffsetDateTime o) {
            return Timestamp.from(o.toInstant());
        }

        public OffsetDateTime convertToEntityAttribute(Timestamp sqlTimestamp) {
            return sqlTimestamp.toInstant().atOffset(ZoneOffset.UTC);
        }
    }
}

