/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.Mutable;

class CalendarComponentDiffDescriptor {
    private static final String TITLE_ATTR = "title";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String LOCATION_ATTR = "location";
    private static final String PRIORITY_ATTR = "priority";
    private static final String SAVE_ATTRIBUTE_ATTR = "save_attribute";
    private static final String REMOVE_ATTRIBUTE_ATTR = "remove_attribute";
    private static final String SAVE_ATTENDEE_ATTR = "save_attendee";
    private static final String REMOVE_ATTENDEE_ATTR = "remove_attendee";
    private static final String UPDATE_ATTENDEE_STATUS_ATTR = "status_attendee";
    private final Map<String, Object> diff = new HashMap<String, Object>();

    private CalendarComponentDiffDescriptor() {
    }

    static CalendarComponentDiffDescriptor diffBetween(CalendarComponent changes, CalendarComponent reference) {
        CalendarComponentDiffDescriptor diffDescriptor = new CalendarComponentDiffDescriptor();
        diffDescriptor.analyze(changes, reference);
        return diffDescriptor;
    }

    boolean existsDiff() {
        return !this.diff.isEmpty();
    }

    boolean mergeInto(CalendarComponent component) {
        Mutable dataMerged = Mutable.of((Object)false);
        if (this.diff.containsKey(TITLE_ATTR)) {
            component.setTitle((String)this.diff.get(TITLE_ATTR));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(DESCRIPTION_ATTR)) {
            component.setDescription((String)this.diff.get(DESCRIPTION_ATTR));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(LOCATION_ATTR)) {
            component.setLocation((String)this.diff.get(LOCATION_ATTR));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(PRIORITY_ATTR)) {
            component.setPriority((Priority)((Object)this.diff.get(PRIORITY_ATTR)));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(SAVE_ATTRIBUTE_ATTR)) {
            Map attributesToSave = (Map)this.diff.get(SAVE_ATTRIBUTE_ATTR);
            attributesToSave.forEach((key, value) -> component.getAttributes().set((String)key, (String)value));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(REMOVE_ATTRIBUTE_ATTR)) {
            Set attributesToRemove = (Set)this.diff.get(REMOVE_ATTRIBUTE_ATTR);
            attributesToRemove.forEach(a -> component.getAttributes().remove((String)a));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(SAVE_ATTENDEE_ATTR)) {
            Set attendeesToSave = (Set)this.diff.get(SAVE_ATTENDEE_ATTR);
            attendeesToSave.forEach(a -> {
                Optional<Attendee> attendee = component.getAttendees().get(a.getId());
                if (attendee.isPresent()) {
                    attendee.get().setPresenceStatus(a.getPresenceStatus());
                } else {
                    component.getAttendees().add(a.copy());
                }
            });
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(REMOVE_ATTENDEE_ATTR)) {
            Set attendeesToRemove = (Set)this.diff.get(REMOVE_ATTENDEE_ATTR);
            attendeesToRemove.forEach(atr -> component.getAttendees().removeIf(a -> a.getId().equals(atr.getId())));
            dataMerged.set((Object)true);
        }
        if (this.diff.containsKey(UPDATE_ATTENDEE_STATUS_ATTR)) {
            Set attendeeStatusesToUpdate = (Set)this.diff.get(UPDATE_ATTENDEE_STATUS_ATTR);
            attendeeStatusesToUpdate.forEach(aS -> {
                Optional<Attendee> attendee = component.getAttendees().get(aS.getId());
                attendee.ifPresent(a -> a.setParticipationStatus(aS.getParticipationStatus()));
                dataMerged.set((Object)attendee.isPresent());
            });
        }
        return dataMerged.is((Object)true);
    }

    private void analyze(CalendarComponent changes, CalendarComponent reference) {
        if (this.areNotEquals(changes.getTitle(), reference.getTitle())) {
            this.diff.put(TITLE_ATTR, changes.getTitle());
        }
        if (this.areNotEquals(changes.getDescription(), reference.getDescription())) {
            this.diff.put(DESCRIPTION_ATTR, changes.getDescription());
        }
        if (this.areNotEquals(changes.getLocation(), reference.getLocation())) {
            this.diff.put(LOCATION_ATTR, changes.getLocation());
        }
        if (this.areNotEquals((Object)changes.getPriority(), (Object)reference.getPriority())) {
            this.diff.put(PRIORITY_ATTR, (Object)changes.getPriority());
        }
        this.analyseAttributes(changes, reference);
        this.analyseAttendees(changes, reference);
    }

    private void analyseAttendees(CalendarComponent left, CalendarComponent right) {
        HashSet attendeeToSave = new HashSet();
        HashSet attendeeToRemove = new HashSet();
        HashSet attendeeStatusToUpdate = new HashSet();
        left.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)aLeft -> {
            Optional<Attendee> aRight = right.getAttendees().get(aLeft.getId());
            if (aRight.isEmpty()) {
                attendeeToSave.add(aLeft);
            } else if (this.areNotEquals((Object)aLeft.getParticipationStatus(), (Object)aRight.get().getParticipationStatus())) {
                attendeeStatusToUpdate.add(aLeft);
            } else if (this.areNotEquals((Object)aLeft.getPresenceStatus(), (Object)aRight.get().getPresenceStatus())) {
                attendeeToSave.add(aLeft);
            }
        }));
        right.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)aRight -> {
            Optional<Attendee> aLeft = left.getAttendees().get(aRight.getId());
            if (aLeft.isEmpty() && attendeeToSave.stream().noneMatch(a -> a.getId().equals(aRight.getId()))) {
                attendeeToRemove.add(aRight);
            }
        }));
        if (!attendeeToSave.isEmpty()) {
            this.diff.put(SAVE_ATTENDEE_ATTR, attendeeToSave);
        }
        if (!attendeeToRemove.isEmpty()) {
            this.diff.put(REMOVE_ATTENDEE_ATTR, attendeeToRemove);
        }
        if (!attendeeStatusToUpdate.isEmpty()) {
            this.diff.put(UPDATE_ATTENDEE_STATUS_ATTR, attendeeStatusToUpdate);
        }
    }

    private void analyseAttributes(CalendarComponent left, CalendarComponent right) {
        HashMap<String, String> attributesToSave = new HashMap<String, String>();
        HashSet<String> attributesToRemove = new HashSet<String>();
        Map<String, String> leftAttributes = left.getAttributes().getData();
        Map<String, String> rightAttributes = right.getAttributes().getData();
        Collection<String> allAttributeKeys = CollectionUtil.union(leftAttributes.keySet(), rightAttributes.keySet());
        for (String key : allAttributeKeys) {
            boolean isOnLeft = leftAttributes.containsKey(key);
            if (isOnLeft) {
                boolean isOnRight = rightAttributes.containsKey(key);
                String leftValue = leftAttributes.get(key);
                if (isOnRight && !this.areNotEquals(leftValue, rightAttributes.get(key))) continue;
                attributesToSave.put(key, leftValue);
                continue;
            }
            attributesToRemove.add(key);
        }
        if (!attributesToSave.isEmpty()) {
            this.diff.put(SAVE_ATTRIBUTE_ATTR, attributesToSave);
        }
        if (!attributesToRemove.isEmpty()) {
            this.diff.put(REMOVE_ATTRIBUTE_ATTR, attributesToRemove);
        }
    }

    private boolean areNotEquals(Object left, Object right) {
        return new EqualsBuilder().append(left, right).build() == false;
    }
}

