/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.constant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum UserAccessLevel {
    UNKNOWN(""),
    ADMINISTRATOR("A"),
    DOMAIN_ADMINISTRATOR("D"),
    SPACE_ADMINISTRATOR("S"),
    USER("U"),
    GUEST("G"),
    PDC_MANAGER("K");

    private final String code;

    private UserAccessLevel(String code) {
        this.code = code;
    }

    public String code() {
        return this.code;
    }

    public String getCode() {
        return this.code();
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static UserAccessLevel fromCode(String code) {
        if (code != null) {
            for (UserAccessLevel userLevelAccess : UserAccessLevel.values()) {
                if (!code.equals(userLevelAccess.code)) continue;
                return userLevelAccess;
            }
        }
        return UNKNOWN;
    }

    @JsonCreator
    public static UserAccessLevel from(String name) {
        if (name != null) {
            for (UserAccessLevel userAccessLevel : UserAccessLevel.values()) {
                if (!name.equals(userAccessLevel.name())) continue;
                return userAccessLevel;
            }
        }
        return UNKNOWN;
    }
}

