/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface RepositoryManagementMBean {
    public static final String TYPE = "RepositoryManagement";

    @Description(value="Creates a backup of the persistent state of the repository")
    @NotNull
    public CompositeData startBackup();

    @Description(value="The status of the ongoing operation, or the terminal status of the last completed backup operation")
    @NotNull
    public CompositeData getBackupStatus();

    @Description(value="Restores the repository from a backup")
    @NotNull
    public CompositeData startRestore();

    @Description(value="The status of the ongoing operation, or the terminal status of the last completed restore operation")
    @NotNull
    public CompositeData getRestoreStatus();

    @Description(value="Initiates a data store garbage collection operation")
    @NotNull
    public CompositeData startDataStoreGC(@Name(value="markOnly") @Description(value="Set to true to only mark references and not sweep in the mark and sweep operation. This mode is to be used when the underlying BlobStore is shared between multiple different repositories. For all other cases set it to false to perform full garbage collection") boolean var1);

    @Description(value="Data store garbage collection status")
    @NotNull
    public CompositeData getDataStoreGCStatus();

    @Description(value="Initiates a revision garbage collection operation")
    @NotNull
    public CompositeData startRevisionGC();

    @Description(value="Initiates a revision garbage collection operation for a given role")
    @NotNull
    public CompositeData startRevisionGCForRole(String var1);

    @Description(value="Cancel a running revision garbage collection operation. Does nothing if revision garbage collection is not running.")
    @NotNull
    public CompositeData cancelRevisionGC();

    @Description(value="Cancel a running revision garbage collection operation. Does nothing if revision garbage collection is not running.")
    @NotNull
    public CompositeData cancelRevisionGCForRole(String var1);

    @Description(value="Revision garbage collection status")
    @NotNull
    public CompositeData getRevisionGCStatus();

    @Description(value="Revision garbage collection status for a given role")
    @NotNull
    public CompositeData getRevisionGCStatusForRole(String var1);

    @Deprecated
    @Nullable
    public String checkpoint(long var1);

    @Description(value="Initiates a reindex operation for the property indexes marked for reindexing")
    @NotNull
    public CompositeData startPropertyIndexAsyncReindex();

    @Description(value="Asynchronous Property Index reindexing status")
    @NotNull
    public CompositeData getPropertyIndexAsyncReindexStatus();

    @Description(value="Refresh all currently open sessions")
    @NotNull
    public TabularData refreshAllSessions();

    @Description(value="The Session.save() delay configuration")
    public String getSessionSaveDelayerConfig();

    @Description(value="The Session.save() delay configuration")
    public void setSessionSaveDelayerConfig(String var1);

    public static enum StatusCode {
        UNAVAILABLE("Operation not available"),
        NONE("Status not available"),
        INITIATED("Operation initiated"),
        RUNNING("Operation running"),
        SUCCEEDED("Operation succeeded"),
        FAILED("Operation failed");

        public final String name;

        private StatusCode(String name) {
            this.name = name;
        }
    }
}

