/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.ietf.jgss.GSSCredential;
import org.silverpeas.spnego.DelegateServletRequest;
import org.silverpeas.spnego.SpnegoPrincipal;

final class SpnegoHttpServletRequest
extends HttpServletRequestWrapper
implements DelegateServletRequest {
    private final transient SpnegoPrincipal principal;

    SpnegoHttpServletRequest(HttpServletRequest request, SpnegoPrincipal spnegoPrincipal) {
        super(request);
        this.principal = spnegoPrincipal;
    }

    public String getAuthType() {
        String header = this.getHeader("Authorization");
        String authType = header.startsWith("Negotiate") ? "Negotiate" : (header.startsWith("Basic") ? "Basic" : super.getAuthType());
        return authType;
    }

    public GSSCredential getDelegatedCredential() {
        return this.principal.getDelegatedCredential();
    }

    public String getRemoteUser() {
        if (null == this.principal) {
            return super.getRemoteUser();
        }
        String principalName = this.principal.getName();
        int indexOfRealm = principalName.lastIndexOf("@");
        if (indexOfRealm >= 0) {
            return principalName.substring(0, indexOfRealm);
        }
        return principalName;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }
}

