/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.datarecord.AbstractProcessInstanceDataRecord;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceRowTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceTemplate;

public class ProcessInstanceRowRecord
extends AbstractProcessInstanceDataRecord {
    private static final long serialVersionUID = 5258805262791365104L;

    public ProcessInstanceRowRecord(ProcessInstance instance, String role, String lang) throws WorkflowException {
        super(instance, role, lang);
    }

    @Override
    protected ProcessInstanceTemplate getTemplate(String role, String lang) throws WorkflowException {
        return (ProcessInstanceRowTemplate)this.instance.getProcessModel().getRowTemplate(role, lang);
    }

    @Override
    public String getId() {
        return this.instance.getInstanceId();
    }

    public boolean isLockedByAdmin() {
        return this.instance.isLockedByAdmin();
    }

    public boolean isInError() {
        return this.instance.getErrorStatus();
    }

    public boolean isInTimeout() {
        return this.instance.getTimeoutStatus();
    }

    public boolean isWorking(User user) {
        if (user == null) {
            return false;
        }
        Actor[] workers = null;
        try {
            workers = this.instance.getWorkingUsers();
        }
        catch (WorkflowException e) {
            return false;
        }
        for (int i = 0; i < workers.length; ++i) {
            if (!user.equals(workers[i].getUser())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getField(String fieldName) throws FormException {
        return this.getField(this.template.getFieldIndex(fieldName));
    }

    @Override
    public String[] getFieldNames() {
        return this.template.getFieldNames();
    }

    public ProcessInstance getFullProcessInstance() {
        return this.instance;
    }
}

