/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.TimeoutEvent;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.core.workflow.engine.WorkflowTools;
import org.silverpeas.kernel.logging.SilverLogger;

class TimeoutRequest
extends AbstractRequest {
    protected TimeoutRequest() {
    }

    public static TimeoutRequest get(TimeoutEvent event) {
        TimeoutRequest request = (TimeoutRequest)ServiceProvider.getService(TimeoutRequest.class, (Annotation[])new Annotation[0]);
        request.setEvent(event);
        return request;
    }

    public void process(AbstractRequestTask.ProcessContext context) throws InterruptedException {
        TimeoutEvent event = (TimeoutEvent)this.getEvent();
        UpdatableProcessInstance instance = (UpdatableProcessInstance)event.getProcessInstance();
        String id = instance.getInstanceId();
        SilverLogger.getLogger((Object)this).info("process() - instanceId = {0}", new Object[]{id});
        UpdatableHistoryStep step = (UpdatableHistoryStep)Transaction.performInOne(() -> this.createHistoryNewStep(new AbstractRequest.HistoryStepDescriptor().withUserRoleName("supervisor").withActionDate(new Date()).withProcessInstance(instance)));
        this.processProcessInstance(id, event, step);
    }

    @Override
    protected boolean processEvent(UpdatableProcessInstance instance, String stepId) throws WorkflowException {
        UpdatableHistoryStep step = (UpdatableHistoryStep)instance.getHistoryStep(stepId);
        instance.updateHistoryStep(step);
        TimeoutEvent event = (TimeoutEvent)this.getEvent();
        instance.addTimeout(event.getResolvedState());
        return WorkflowTools.processAction(instance, event, step, false);
    }
}

