/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.lang.annotation.Annotation;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.TaskManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.event.QuestionEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Participant;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.core.workflow.engine.WorkflowHub;

class QuestionRequest
extends AbstractRequest {
    protected QuestionRequest() {
    }

    public static QuestionRequest get(QuestionEvent event) {
        QuestionRequest request = (QuestionRequest)ServiceProvider.getService(QuestionRequest.class, (Annotation[])new Annotation[0]);
        request.setEvent(event);
        return request;
    }

    public void process(AbstractRequestTask.ProcessContext context) throws InterruptedException {
        Object event = this.getEvent();
        UpdatableProcessInstance instance = (UpdatableProcessInstance)event.getProcessInstance();
        String id = instance.getInstanceId();
        UpdatableHistoryStep step = (UpdatableHistoryStep)Transaction.performInOne(() -> this.createHistoryNewStep(new AbstractRequest.HistoryStepDescriptor().withActionName("#question#").withProcessInstance(instance)));
        this.processProcessInstance(id, (GenericEvent)event, step);
    }

    @Override
    protected boolean processEvent(UpdatableProcessInstance instance, String stepId) throws WorkflowException {
        String question;
        UpdatableHistoryStep step = (UpdatableHistoryStep)instance.getHistoryStep(stepId);
        instance.updateHistoryStep(step);
        QuestionEvent event = (QuestionEvent)this.getEvent();
        try {
            question = (String)event.getDataRecord().getField("Content").getObjectValue();
        }
        catch (FormException fe) {
            throw new WorkflowException("WorkflowEngineThread.process", "workflowEngine.EXP_UNKNOWN_ITEM", (Exception)((Object)fe));
        }
        State state = instance.addQuestion(question, event.getStepId(), event.getResolvedState(), event.getUser());
        instance.addActiveState(state);
        step.setActionStatus(ActionStatus.PROCESSED);
        instance.updateHistoryStep(step);
        Participant participant = instance.getParticipant(state.getName());
        TaskManager taskManager = WorkflowHub.getTaskManager();
        Task task = taskManager.createTask(participant, instance);
        taskManager.assignTask(task, participant.getUser());
        instance.addWorkingUser(participant.getUser(), state, participant.getUserRoleName());
        step.setActionStatus(ActionStatus.AFFECTATIONS_DONE);
        instance.updateHistoryStep(step);
        instance.unLock();
        return false;
    }
}

