/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ItemNamePattern
implements RestrictionPattern {
    private final Set<String> names;

    ItemNamePattern(Iterable<String> names) {
        this.names = Collections.unmodifiableSet(SetUtils.toLinkedSet(names));
    }

    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        if (property != null) {
            return this.names.contains(property.getName());
        }
        return this.names.contains(tree.getName());
    }

    public boolean matches(@NotNull String path) {
        return !PathUtils.denotesRoot((String)path) && this.names.contains(PathUtils.getName((String)path));
    }

    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        return this.names.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemNamePattern) {
            ItemNamePattern other = (ItemNamePattern)obj;
            return this.names.equals(other.names);
        }
        return false;
    }
}

