/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringConstraint
implements Predicate<Value> {
    private static final Logger log = LoggerFactory.getLogger(StringConstraint.class);
    private final Pattern pattern;

    public StringConstraint(String definition) {
        Pattern p;
        try {
            p = Pattern.compile(definition);
        }
        catch (PatternSyntaxException pse) {
            String msg = "'" + definition + "' is not valid regular expression syntax";
            log.warn(msg);
            p = null;
        }
        this.pattern = p;
    }

    @Override
    public boolean test(Value value) {
        if (value == null) {
            return false;
        }
        try {
            Matcher matcher = this.pattern.matcher(value.getString());
            return matcher.matches();
        }
        catch (RepositoryException e) {
            log.warn("Error checking string constraint " + this, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "'" + this.pattern + "'";
    }
}

