/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Mutable<T> {
    private T value;

    private Mutable() {
        this.value = null;
    }

    private Mutable(T value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public static <T> Mutable<T> of(T value) {
        return new Mutable<T>(value);
    }

    public static <T> Mutable<T> ofNullable(T value) {
        return value == null ? new Mutable<T>() : new Mutable<T>(value);
    }

    public static <T> Mutable<T> empty() {
        return new Mutable<T>();
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public boolean is(T value) {
        return Objects.equals(this.value, value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public Mutable<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : new Mutable<T>();
    }

    public <U> Mutable<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return new Mutable<T>();
        }
        return Mutable.ofNullable(mapper.apply(this.value));
    }

    public <U> Mutable<U> flatMap(Function<? super T, Mutable<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return new Mutable<T>();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mutable)) {
            return false;
        }
        Mutable other = (Mutable)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Mutable[%s]", this.value) : "Mutable.nullValue";
    }
}

