/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.logging;

import java.util.function.Supplier;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLoggerProvider;

public interface SilverLogger {
    public static SilverLogger getLogger(String module) {
        return SilverLoggerProvider.getInstance().getLogger(module);
    }

    public static SilverLogger getLogger(Object object) {
        return SilverLoggerProvider.getInstance().getLogger(object);
    }

    public String getNamespace();

    public Level getLevel();

    public void setLevel(Level var1);

    public boolean isLoggable(Level var1);

    public void log(Level var1, String var2, Object[] var3, Throwable var4);

    public void log(Level var1, String var2, Object ... var3);

    default public void error(String message, Object ... parameters) {
        this.log(Level.ERROR, message, parameters);
    }

    default public void error(Throwable error) {
        this.log(Level.ERROR, error.getMessage(), (Object[])new String[0], error);
    }

    default public void error(String message, Throwable error) {
        this.log(Level.ERROR, message, (Object[])new String[0], error);
    }

    default public void error(String message, Object[] parameters, Throwable error) {
        this.log(Level.ERROR, message, parameters, error);
    }

    default public void warn(String message, Object ... parameters) {
        this.log(Level.WARNING, message, parameters);
    }

    default public void warn(Throwable error) {
        this.log(Level.WARNING, error.getMessage(), new Object[0]);
    }

    default public void info(String message, Object ... parameters) {
        this.log(Level.INFO, message, parameters);
    }

    default public void debug(String message, Object ... parameters) {
        this.log(Level.DEBUG, message, parameters);
    }

    default public void debug(Supplier<String> messageSupplier) {
        if (this.isLoggable(Level.DEBUG)) {
            this.log(Level.DEBUG, messageSupplier.get(), null, null);
        }
    }

    default public SilverLogger silent(Throwable error) {
        return this;
    }
}

