/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.cache.model;

import java.util.UUID;
import java.util.function.Supplier;
import org.silverpeas.kernel.cache.model.AbstractSimpleCache;
import org.silverpeas.kernel.cache.model.Cache;

public abstract class ExternalCache
extends AbstractSimpleCache
implements Cache {
    private static final int DEFAULT_TIME_TO_IDLE = 43200;

    @Override
    public String add(Object value, int timeToLive) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value, timeToLive);
        return uniqueKey;
    }

    @Override
    public String add(Object value, int timeToLive, int timeToIdle) {
        String uniqueKey = UUID.randomUUID().toString();
        this.put(uniqueKey, value, timeToLive, timeToIdle);
        return uniqueKey;
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(Object key, Object value, int timeToLive) {
        this.put(key, value, timeToLive, 43200);
    }

    @Override
    public <T> T computeIfAbsent(Object key, Class<T> classType, Supplier<T> valueSupplier) {
        return this.computeIfAbsent(key, classType, 0, valueSupplier);
    }

    @Override
    public <T> T computeIfAbsent(Object key, Class<T> classType, int timeToLive, Supplier<T> valueSupplier) {
        return this.computeIfAbsent(key, classType, timeToLive, 43200, valueSupplier);
    }
}

