/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Date;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.sharing.model.NodeTicket;
import org.silverpeas.core.sharing.model.PublicationTicket;
import org.silverpeas.core.sharing.model.SimpleFileTicket;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.model.VersionFileTicket;

public class TicketFactory {
    public static Ticket aTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax, String type) {
        if (TicketFactory.isUserAllowed(sharedObjectId, componentId, creatorId, type)) {
            if ("Attachment".equalsIgnoreCase(type)) {
                return new SimpleFileTicket(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
            }
            if ("Versionned".equalsIgnoreCase(type)) {
                return new VersionFileTicket(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
            }
            if ("Node".equalsIgnoreCase(type)) {
                return new NodeTicket(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
            }
            if ("Publication".equalsIgnoreCase(type)) {
                return new PublicationTicket(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
            }
        }
        return null;
    }

    public static Ticket continuousTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, String type) {
        return TicketFactory.aTicket(sharedObjectId, componentId, creatorId, creationDate, null, -1, type);
    }

    private static boolean isUserAllowed(int sharedObjectId, String componentId, String creatorId, String type) {
        if ("Attachment".equalsIgnoreCase(type) || "Versionned".equalsIgnoreCase(type)) {
            SimpleDocumentPK pk = new SimpleDocumentPK(null, componentId);
            pk.setOldSilverpeasId((long)sharedObjectId);
            SimpleDocument doc = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, null);
            return doc.isSharingAllowedForRolesFrom((User)UserDetail.getById((String)creatorId));
        }
        if ("Node".equalsIgnoreCase(type)) {
            return NodeAccessControl.get().isUserAuthorized(creatorId, (Object)new NodePK(String.valueOf(sharedObjectId), componentId), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SHARING}));
        }
        if ("Publication".equalsIgnoreCase(type)) {
            return PublicationAccessControl.get().isUserAuthorized(creatorId, (Object)new PublicationPK(String.valueOf(sharedObjectId), componentId), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SHARING}));
        }
        return false;
    }
}

