/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.sharing.model.SimpleFileAccessControl;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.ShareableAccessControl;
import org.silverpeas.core.sharing.security.ShareableAttachment;
import org.silverpeas.core.sharing.security.ShareableResource;

@Entity
@DiscriminatorValue(value="Attachment")
public class SimpleFileTicket
extends Ticket {
    private static final long serialVersionUID = -475026338727454787L;

    protected SimpleFileTicket() {
        this.sharedObjectType = "Attachment";
    }

    public SimpleFileTicket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Attachment";
    }

    public SimpleFileTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Attachment";
    }

    @Override
    @Transient
    public ShareableAccessControl getAccessControl() {
        return new SimpleFileAccessControl(this);
    }

    public SimpleFileTicket(String key, int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.setId(key);
    }

    @Transient
    public ShareableResource<SimpleDocument> getResource() {
        SimpleDocumentPK pk = new SimpleDocumentPK(null, this.getComponentId());
        pk.setOldSilverpeasId(this.getSharedObjectId());
        SimpleDocument doc = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, null);
        if (doc != null) {
            return new ShareableAttachment(this.getToken(), doc.getLastPublicVersion());
        }
        return null;
    }
}

