/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mylinks.dao;

import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.mylinks.dao.CategoryDAO;
import org.silverpeas.core.mylinks.dao.LinkDAO;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.Pair;

@Repository
public class LinkCategoryDAO {
    private static final String LINK_CATEGORY_TABLE = "SB_MyLinks_LinkCat";
    private static final String LINK_ID = "linkId";
    private static final String CAT_ID = "catId";
    private static final String LINK_ID_CLAUSE = "linkId = ?";
    private static final String CAT_ID_CLAUSE = "catId = ?";
    @Inject
    private CategoryDAO categoryDAO;

    protected static LinkCategoryDAO get() {
        return (LinkCategoryDAO)ServiceProvider.getService(LinkCategoryDAO.class, (Annotation[])new Annotation[0]);
    }

    protected LinkCategoryDAO() {
    }

    protected void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.executeBySplittingOn(LinkDAO.get().getLinkIdsByComponentInstance(componentInstanceId), (linkIdBatch, ignored) -> JdbcSqlQuery.deleteFrom((String)LINK_CATEGORY_TABLE).where(LINK_ID, new Object[0]).in(linkIdBatch).execute());
    }

    protected void deleteUserData(String userId) throws SQLException {
        JdbcSqlQuery.executeBySplittingOn((Collection)this.categoryDAO.getAllCategoriesByUser(userId).stream().map(CategoryDetail::getId).collect(Collectors.toList()), (catIdBatch, ignored) -> JdbcSqlQuery.deleteFrom((String)LINK_CATEGORY_TABLE).where(CAT_ID, new Object[0]).in(catIdBatch).execute());
    }

    protected Map<Integer, CategoryDetail> getAllCategoriesByLinkOfUser(String userId) throws SQLException {
        Map<Integer, CategoryDetail> categoriesById = this.categoryDAO.getAllCategoriesByUser(userId).stream().collect(Collectors.toMap(CategoryDetail::getId, c -> c));
        return JdbcSqlQuery.executeBySplittingOn(categoriesById.keySet(), (catIdBatch, result) -> JdbcSqlQuery.select((String)"*").from(new String[]{LINK_CATEGORY_TABLE}).where(CAT_ID, new Object[0]).in(catIdBatch).execute(rs -> {
            MapUtil.putAddList((Map)result, (Object)rs.getInt(CAT_ID), (Object)rs.getInt(LINK_ID));
            return null;
        })).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(l -> Pair.of((Object)((Integer)l), (Object)((CategoryDetail)categoriesById.get(e.getKey()))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    protected Map<Integer, CategoryDetail> getAllCategoriesByLink(int linkId) throws SQLException {
        ListSlice categoryIds = JdbcSqlQuery.select((String)CAT_ID).from(new String[]{LINK_CATEGORY_TABLE}).where(LINK_ID_CLAUSE, new Object[]{linkId}).execute(rs -> rs.getInt(1));
        return this.categoryDAO.getCategories((Collection<Integer>)categoryIds).stream().collect(Collectors.toMap(c -> linkId, c -> c));
    }

    protected void saveByLink(LinkDetail link) throws SQLException {
        Integer previousCat = (Integer)JdbcSqlQuery.select((String)CAT_ID).from(new String[]{LINK_CATEGORY_TABLE}).where(LINK_ID_CLAUSE, new Object[]{link.getLinkId()}).executeUnique(rs -> rs.getInt(1));
        if (link.getCategory() == null) {
            if (previousCat != null) {
                this.deleteByLink(link.getLinkId());
            }
        } else if (previousCat == null || !previousCat.equals(link.getCategory().getId())) {
            JdbcSqlQuery saveQuery;
            boolean isInsert;
            if (!link.getUserId().equals(link.getCategory().getUserId())) {
                throw new IllegalArgumentException("user id mismatches between link and category");
            }
            boolean bl = isInsert = previousCat == null;
            if (isInsert) {
                saveQuery = JdbcSqlQuery.insertInto((String)LINK_CATEGORY_TABLE);
                saveQuery.withSaveParam(LINK_ID, (Object)link.getLinkId(), true);
            } else {
                saveQuery = JdbcSqlQuery.update((String)LINK_CATEGORY_TABLE);
            }
            saveQuery.withSaveParam(CAT_ID, (Object)link.getCategory().getId(), isInsert);
            if (!isInsert) {
                saveQuery.where(LINK_ID_CLAUSE, new Object[]{link.getLinkId()});
            }
            saveQuery.execute();
        }
    }

    protected void deleteByLink(int linkId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)LINK_CATEGORY_TABLE).where(LINK_ID_CLAUSE, new Object[]{linkId}).execute();
    }

    protected void deleteByCategory(int catId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)LINK_CATEGORY_TABLE).where(CAT_ID_CLAUSE, new Object[]{catId}).execute();
    }
}

