/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.servers;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.ChatServerException;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.chat.ChatUser;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.chat.servers.DefaultChatServer;
import org.silverpeas.core.chat.servers.HttpRequester;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.logging.SilverLogger;

@DefaultChatServer
@Service
public class EJabberdServer
implements ChatServer {
    private static final String HOST_ATTR = "host";
    private static final String SERVER_ATTR = "server";
    private static final String LOCAL_SERVER_ATTR = "localserver";
    private static final String PASS_ATTR = "password";
    private static final String USER_ATTR = "user";
    private static final String LOCAL_USER_ATTR = "localuser";
    private static final String NICK_ATTR = "nick";
    private static final String SUBSCRIPTION_ATTR = "subs";
    private static final String NAME_ATTR = "name";
    private static final String CONTENT_ATTR = "content";
    private static final String GROUP_ATTR = "group";
    private final SilverLogger logger = SilverLogger.getLogger((Object)this);
    private final String url;
    private final HttpRequester requester;

    public EJabberdServer() {
        ChatSettings settings = ChatServer.getChatSettings();
        this.url = settings.getRestApiUrl();
        String key = settings.getRestApiAuthToken();
        this.requester = new HttpRequester("Bearer " + key);
    }

    @Override
    public void createUser(User user) {
        SilverLogger.getLogger((Object)this).debug("Register user {0} ({1})", new Object[]{user.getDisplayedName(), user.getId()});
        ChatUser chatUser = ChatUser.fromUser(user);
        this.request("register", o -> o.put(USER_ATTR, chatUser.getChatLogin()).put(HOST_ATTR, chatUser.getChatDomain()).put(PASS_ATTR, chatUser.getChatPassword()));
        this.request("set_vcard", o -> o.put(USER_ATTR, chatUser.getChatLogin()).put(HOST_ATTR, chatUser.getChatDomain()).put(NAME_ATTR, "FN").put(CONTENT_ATTR, chatUser.getDisplayedName()));
    }

    @Override
    public void deleteUser(User user) {
        SilverLogger.getLogger((Object)this).debug("Unregister user {0} ({1})", new Object[]{user.getDisplayedName(), user.getId()});
        ChatUser chatUser = ChatUser.fromUser(user);
        this.request("unregister", o -> o.put(USER_ATTR, chatUser.getChatLogin()).put(HOST_ATTR, chatUser.getChatDomain()));
    }

    @Override
    public void createRelationShip(User user1, User user2) {
        SilverLogger.getLogger((Object)this).debug("Add relationships between {0} ({1}) and {2} ({3})", new Object[]{user1.getDisplayedName(), user1.getId(), user2.getDisplayedName(), user2.getId()});
        ChatUser chatUser1 = ChatUser.fromUser(user1);
        ChatUser chatUser2 = ChatUser.fromUser(user2);
        String command = "add_rosteritem";
        this.request("add_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser2.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser2.getChatDomain()).put(USER_ATTR, chatUser1.getChatLogin()).put(SERVER_ATTR, chatUser1.getChatDomain()).put(NICK_ATTR, chatUser1.getDisplayedName()).put(GROUP_ATTR, "").put(SUBSCRIPTION_ATTR, "to"));
        this.request("add_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser1.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser1.getChatDomain()).put(USER_ATTR, chatUser2.getChatLogin()).put(SERVER_ATTR, chatUser2.getChatDomain()).put(NICK_ATTR, chatUser2.getDisplayedName()).put(GROUP_ATTR, "").put(SUBSCRIPTION_ATTR, "to"));
        this.request("add_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser2.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser2.getChatDomain()).put(USER_ATTR, chatUser1.getChatLogin()).put(SERVER_ATTR, chatUser1.getChatDomain()).put(NICK_ATTR, chatUser1.getDisplayedName()).put(GROUP_ATTR, "").put(SUBSCRIPTION_ATTR, "both"));
        this.request("add_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser1.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser1.getChatDomain()).put(USER_ATTR, chatUser2.getChatLogin()).put(SERVER_ATTR, chatUser2.getChatDomain()).put(NICK_ATTR, chatUser2.getDisplayedName()).put(GROUP_ATTR, "").put(SUBSCRIPTION_ATTR, "both"));
    }

    @Override
    public void deleteRelationShip(User user1, User user2) {
        SilverLogger.getLogger((Object)this).debug("Delete relationships between {0} ({1}) and {2} ({3})", new Object[]{user1.getDisplayedName(), user1.getId(), user2.getDisplayedName(), user2.getId()});
        ChatUser chatUser1 = ChatUser.fromUser(user1);
        ChatUser chatUser2 = ChatUser.fromUser(user2);
        String command = "delete_rosteritem";
        this.request("delete_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser2.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser2.getChatDomain()).put(USER_ATTR, chatUser1.getChatLogin()).put(SERVER_ATTR, chatUser1.getChatDomain()));
        this.request("delete_rosteritem", o -> o.put(LOCAL_USER_ATTR, chatUser1.getChatLogin()).put(LOCAL_SERVER_ATTR, chatUser1.getChatDomain()).put(USER_ATTR, chatUser2.getChatLogin()).put(SERVER_ATTR, chatUser2.getChatDomain()));
    }

    @Override
    public boolean isUserExisting(User user) {
        ChatUser chatUser = ChatUser.fromUser(user);
        return this.request("check_account", o -> o.put(USER_ATTR, chatUser.getChatLogin()).put(HOST_ATTR, chatUser.getChatDomain()), r -> (Integer)r.readEntity(Integer.class) == 0);
    }

    private void request(String command, UnaryOperator<JSONCodec.JSONObject> argsProvider) {
        this.request(command, argsProvider, r -> null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T request(String command, UnaryOperator<JSONCodec.JSONObject> argsProvider, Function<Response, T> responseProcessor) {
        try (Response response = this.requester.at(this.url, command).header("X-Admin", "true").post(argsProvider);){
            if (response.getStatus() != 200) {
                this.processError(command, response);
            }
            Response t = responseProcessor.apply(response);
            return (T)t;
        }
        catch (Exception e) {
            throw new ChatServerException("Error while performing " + command + ": " + e.getMessage(), e);
        }
    }

    private void processError(String command, Response response) {
        this.logger.error("Failed to {0}: {1}", new Object[]{command, response.getStatusInfo().getReasonPhrase()});
        if (response.getStatus() == 403) {
            throw new ChatServerException("Access to " + command + " is forbidden! Please check your authentication token");
        }
        if (response.getStatus() == 401) {
            throw new ChatServerException("Access to " + command + " is forbidden! Please check your authorization to the " + command + " resource");
        }
        throw new ChatServerException(response.getStatusInfo().getReasonPhrase() + ": " + (String)response.readEntity(String.class));
    }
}

