<%--
  Copyright (C) 2000 - 2024 Silverpeas

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.

  As a special exception to the terms and conditions of version 3.0 of
  the GPL, you may redistribute this Program in connection with Free/Libre
  Open Source Software ("FLOSS") applications as described in Silverpeas's
  FLOSS exception. You should have received a copy of the text describing
  the FLOSS exception, and it is also available here:
  "http://www.silverpeas.org/docs/core/legal/floss_exception.html"

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <https://www.gnu.org/licenses/>.
  --%>

<%@ tag language="java" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://www.silverpeas.com/tld/silverFunctions" prefix="silfn" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://www.silverpeas.com/tld/viewGenerator" prefix="view" %>

<c:set var="userLanguage" value="${sessionScope['SilverSessionController'].favoriteLanguage}"/>
<fmt:setLocale value="${userLanguage}"/>
<view:setBundle basename="org.silverpeas.util.attachment.multilang.attachment"/>

<%@ attribute name="domSelector" required="true"
              type="java.lang.String"
              description="The DOM selector that permits to identify the drop zone" %>
<%@ attribute name="componentInstanceId" required="true"
              type="java.lang.String"
              description="The component instance id associated to the drag and drop" %>
<%@ attribute name="resourceId" required="true"
              type="java.lang.String"
              description="The identifier of the resource the uploaded document must be attached to" %>
<%@ attribute name="resourceType" required="true"
              type="java.lang.String"
              description="The type of the resource the uploaded document must be attached to" %>
<%@ attribute name="contentLanguage" required="true"
              type="java.lang.String"
              description="The content language in which the attachment is uploaded" %>
<%@ attribute name="hasToBeIndexed" required="true"
              type="java.lang.Boolean"
              description="Indicates if the attachment must be indexed" %>
<%@ attribute name="documentType" required="true"
              type="java.lang.String"
              description="Indicates the type of attachment (attachment, wysiwyg, image, ...)" %>

<%@ attribute name="simpleMode" required="false"
              type="java.lang.Boolean"
              description="Must specific behaviors be enabled? False (default value) enable specific behaviors (like I18n content, versionning, etc.)" %>
<c:if test="${simpleMode == null}">
  <c:set var="simpleMode" value="${false}"/>
</c:if>
<%@ attribute name="highestUserRole" required="false"
              type="org.silverpeas.core.admin.user.model.SilverpeasRole"
              description="The highest role the user has" %>
<c:if test="${empty highestUserRole}">
  <c:set var="highestUserRole" value="${silfn:getHighestRoleOfCurrentUserOn(componentInstanceId)}"/>
</c:if>
<%@ attribute name="helpCoverClass" required="false"
              type="java.lang.String"
              description="Specify a class to change display of help access icon" %>
<c:if test="${empty helpCoverClass}">
  <c:set var="helpCoverClass" value="droparea-cover-help-attachment"/>
</c:if>
<%@ attribute name="isHandledModificationContext" required="false"
              type="java.lang.Boolean"
              description="Is handled modification context enabled?" %>
<%@ attribute name="handledSubscriptionType" required="false"
              type="java.lang.String"
              description="The the subscription notification type to manage, if any." %>
<%@ attribute name="handledSubscriptionResourceId" required="false"
              type="java.lang.String"
              description="The resource id of subscription notification to manage, if any." %>
<%@ attribute name="handledSubscriptionLocationId" required="false"
              type="java.lang.String"
              description="The location id of location the subscription notification is managed, if any." %>
<c:if test="${isHandledModificationContext == null}">
  <c:set var="isHandledModificationContext" value="${false}"/>
</c:if>
<c:set var="isHandledSubscriptionConfirmation"
       value="${not empty handledSubscriptionType and not empty handledSubscriptionResourceId}"/>
<%@ attribute name="completedUrlSuccessCallback" required="false"
              type="java.lang.String"
              description="The JS callback on success operation about completed url management." %>
<c:if test="${empty completedUrlSuccessCallback}">
  <c:set var="completedUrlSuccessCallback" value="uploadCompleted"/>
</c:if>

<view:setConstant var="writerRole" constant="org.silverpeas.core.admin.user.model.SilverpeasRole.WRITER"/>
<jsp:useBean id="writerRole" type="org.silverpeas.core.admin.user.model.SilverpeasRole"/>
<view:setConstant var="publisherRole" constant="org.silverpeas.core.admin.user.model.SilverpeasRole.PUBLISHER"/>
<jsp:useBean id="publisherRole" type="org.silverpeas.core.admin.user.model.SilverpeasRole"/>
<c:if test="${highestUserRole.isGreaterThanOrEquals(writerRole)}">

  <c:set var="domIdSuffix" value="${fn:replace(fn:replace(resourceId, '=', '_'), '-', '_')}"/>

  <c:set var="_ddIsI18n" value="${not simpleMode and silfn:isI18n() and silfn:isDefined(contentLanguage)}"/>

  <view:componentParam var="publicationAlwaysVisiblePramValue" componentId="${componentInstanceId}" parameter="publicationAlwaysVisible"/>
  <view:componentParam var="isComponentVersioned" componentId="${componentInstanceId}" parameter="versionControl"/>
  <c:set var="isPublicationAlwaysVisible" value="${silfn:booleanValue(publicationAlwaysVisiblePramValue)}"/>
  <c:set var="isVersionActive" value="${not simpleMode and not isPublicationAlwaysVisible and silfn:booleanValue(isComponentVersioned)}"/>

  <view:componentParam var="commentActivated" componentId="${componentInstanceId}" parameter="tabComments"/>
  <c:if test="${not silfn:booleanValue(commentActivated)}">
    <view:componentParam var="commentActivated" componentId="${componentInstanceId}" parameter="comments"/>
  </c:if>

  <view:includePlugin name="dragAndDropUpload"/>

  <c:url var="uploadCompletedUrl" value="/DragAndDrop/drop">
    <c:param name="ComponentId" value="${componentInstanceId}"/>
    <c:param name="ResourceId" value="${resourceId}"/>
    <c:param name="IndexIt" value="${hasToBeIndexed and highestUserRole.isGreaterThanOrEquals(publisherRole)}"/>
    <c:param name="DocumentType" value="${documentType}"/>
  </c:url>

  <c:url var="helpUrl" value="/upload/Attachment_${userLanguage}.jsp">
    <c:if test="${isVersionActive}">
      <c:param name="mode" value="version"/>
    </c:if>
  </c:url>

  <c:if test="${_ddIsI18n or isVersionActive}">
    <div id="validationDialog${domIdSuffix}" class="form-container" style="display: none;">
      <c:if test="${_ddIsI18n}">
        <br/>

        <div>
          <label for="ddLangCreateId${domIdSuffix}" class="label"><fmt:message key="GML.language"/></label>
          <span class="champ-ui-dialog">
            <view:langSelect elementName="ddLangCreate${domIdSuffix}"
                             elementId="ddLangCreateId${domIdSuffix}"
                             langCode="${contentLanguage}"
                             includeLabel="false"/>
          </span>

          <div style="height: 2px"></div>
        </div>
      </c:if>
      <c:if test="${isVersionActive}">
        <br/>

        <div>
          <span class="label"><fmt:message key="attachment.dragAndDrop.question"/></span>

          <div>
            <input value="0" type="radio" name="versionType${domIdSuffix}" id="publicVersion${domIdSuffix}" checked="checked"/>
            <label for="publicVersion${domIdSuffix}"><fmt:message key="attachment.version_public.label"/></label><br/>
            <input value="1" type="radio" name="versionType${domIdSuffix}" id="workVersion${domIdSuffix}"/>
            <label for="workVersion${domIdSuffix}"><fmt:message key="attachment.version_wip.label"/></label>
          </div>
        </div>
      </c:if>
    </div>
  </c:if>

  <script type="text/JavaScript">
    (function() {
      let options = {
        domSelector : '${domSelector}',
        componentInstanceId : "${componentInstanceId}",
        onCompletedUrl : "${uploadCompletedUrl}",
        onCompletedUrlSuccess : ${completedUrlSuccessCallback},
        helpContentUrl : "${helpUrl}",
        helpCoverClass : "${helpCoverClass}"
      };

      const _performDdWithContributionModificationManagement =
              function (fileUpload, resolve, reject) {
        let rejectOnClose = true;
        if (${isHandledModificationContext}) {
          jQuery.contributionModificationContext.validateOnUpdate({
            contributionId : {
              componentInstanceId : '${componentInstanceId}',
              localId : '${resourceId}',
              type : '${resourceType}'
            },
            callback : function(userResponse) {
              rejectOnClose = false;
              _performDdWithPotentialNotification.call(this, fileUpload, userResponse, resolve, reject);
            },
            callbackOnClose : function() {
              if (rejectOnClose) {
                reject();
              }
            }
          });
        } else {
          _performDdWithPotentialNotification.call(this, fileUpload, null, resolve, reject);
        }
      };

      const _performDdWithPotentialNotification =
              function (fileUpload, userModificationContextResponse, resolve, reject) {
        function __applyModificationContextResponse(ajaxOptions) {
          if (userModificationContextResponse) {
            ajaxOptions = userModificationContextResponse.applyOnAjaxOptions(ajaxOptions);
          }
          return ajaxOptions;
        }
        <c:choose>
        <c:when test="${isHandledSubscriptionConfirmation}">
        let rejectOnClose = true;
        $.subscription.confirmNotificationSendingOnUpdate({
          contribution : {
            contributionId : {
              componentInstanceId : '${componentInstanceId}',
              localId : '${resourceId}',
              type : '${resourceType}'
            },
            locationId : '${handledSubscriptionLocationId}',
            indexable : ${hasToBeIndexed}
          },
          comment : {
            saveNote : ${silfn:booleanValue(commentActivated)}
          },
          subscription : {
            componentInstanceId : '${componentInstanceId}',
            type : '${handledSubscriptionType}',
            resourceId : '${handledSubscriptionResourceId}'
          },
          callback : function(userResponse) {
            rejectOnClose = false;
            let ajaxOptions = userResponse.applyOnAjaxOptions();
            ajaxOptions = __applyModificationContextResponse(ajaxOptions);
            fileUpload.uploadSession.onCompleted.urlHeaders = ajaxOptions.headers;
            resolve();
          },
          callbackOnClose : function() {
            if (rejectOnClose) {
              reject();
            }
          }
        });
        </c:when>
        <c:otherwise>
        resolve();
        </c:otherwise>
        </c:choose>
      };

      <c:choose>
      <c:when test="${_ddIsI18n or isVersionActive}">
      options.beforeSend = function(fileUpload) {
        if (fileUpload.uploadSession.id) {
          return Promise.resolve();
        }
        return new Promise(function(resolve, reject) {
          let rejectOnClose = true;
          jQuery('#validationDialog${domIdSuffix}').popup('validation', {
            title : '<fmt:message key="attachment.dragAndDrop.title" />',
            buttonDisplayed : true,
            isMaxWidth : true,
            callback : function() {
              rejectOnClose = false;
              let uploadCompletedUrl = '${uploadCompletedUrl}';
              <c:if test="${_ddIsI18n}">
              let contentLanguage = jQuery('select[name=ddLangCreate${domIdSuffix}]', this).val();
              uploadCompletedUrl += '&ContentLanguage=' + contentLanguage;
              </c:if>
              <c:if test="${isVersionActive}">
              let version = jQuery('input[name=versionType${domIdSuffix}]:checked', this).val();
              uploadCompletedUrl += '&Type=' + version;
              </c:if>
              fileUpload.uploadSession.onCompleted.url = uploadCompletedUrl;
              _performDdWithContributionModificationManagement.call(this, fileUpload, resolve, reject);
              return true;
            },
            callbackOnClose : function() {
              if (rejectOnClose) {
                reject();
              }
            }
          });
        });
      };
      </c:when>
      <c:otherwise>
      options.beforeSend = function(fileUpload) {
        if (fileUpload.uploadSession.id) {
          return Promise.resolve();
        }
        return new Promise(function(resolve, reject) {
          _performDdWithContributionModificationManagement.call(this, fileUpload, resolve, reject);
        });
      };
      </c:otherwise>
      </c:choose>

      initDragAndDropUploadAndReload(options);
    })();
  </script>
</c:if>