/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.util.SubscriptionUtil;

public class SubscriptionList
extends ArrayList<Subscription> {
    private static final long serialVersionUID = -2314233862350010699L;

    public SubscriptionList() {
    }

    public SubscriptionList(@Nonnull Collection<? extends Subscription> c) {
        super(c);
    }

    public SubscriptionList filterOnDomainVisibilityFrom(UserDetail user) {
        if (user.isDomainRestricted()) {
            Iterator itOfSubscriptions = this.iterator();
            while (itOfSubscriptions.hasNext()) {
                Subscription subscription = (Subscription)itOfSubscriptions.next();
                if (SubscriptionUtil.isSameVisibilityAsTheCurrentRequester(subscription.getSubscriber(), user)) continue;
                itOfSubscriptions.remove();
            }
        }
        return this;
    }
}

