/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.text.MessageFormat;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.AbstractSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.SubscribeRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class UserSubscriptionSubscriber
extends AbstractSubscriptionSubscriber {
    public static UserSubscriptionSubscriber from(String userId) {
        return new UserSubscriptionSubscriber(userId);
    }

    protected UserSubscriptionSubscriber(String id) {
        super(id, SubscriberType.USER);
    }

    @Override
    public void checkValid() throws SubscribeRuntimeException {
        if (StringUtil.isNotDefined((String)this.getId())) {
            throw new SubscribeRuntimeException("user identifier is not specified");
        }
        User user = Optional.ofNullable(User.getById((String)this.getId())).orElseThrow(() -> new SubscribeRuntimeException(MessageFormat.format("user with identifier {0} not found", this.getId())));
        if (user.isAnonymous() || user.isAccessGuest()) {
            throw new SubscribeRuntimeException("user MUST not be an anonymous or a guest one");
        }
    }
}

