/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.token.persistent.service;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.TokenGenerationParameter;
import org.silverpeas.core.security.token.TokenGenerator;
import org.silverpeas.core.security.token.TokenGeneratorProvider;
import org.silverpeas.core.security.token.exception.TokenException;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;
import org.silverpeas.core.security.token.persistent.repository.PersistentResourceTokenRepository;
import org.silverpeas.core.security.token.persistent.service.PersistentResourceTokenService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultTokenService
implements PersistentResourceTokenService {
    @Inject
    private PersistentResourceTokenRepository tokenRepository;

    @Transactional(value=Transactional.TxType.REQUIRED)
    public PersistentResourceToken initialize(EntityReference resource) throws TokenException {
        TokenGenerator generator = TokenGeneratorProvider.getTokenGenerator(PersistentResourceToken.class);
        PersistentResourceToken token = this.get(resource);
        token = token.notExists() ? (PersistentResourceToken)generator.generate(new TokenGenerationParameter[]{TokenGenerationParameter.params((String)"Resource", (Object)resource)}) : (PersistentResourceToken)generator.renew((Token)token);
        token.validate();
        this.tokenRepository.save((IdentifiableEntity)token);
        return token;
    }

    public PersistentResourceToken get(EntityReference resource) {
        return this.bind(this.tokenRepository.getByTypeAndResourceId(resource.getType(), resource.getId()));
    }

    public PersistentResourceToken get(String token) {
        return this.bind(this.tokenRepository.getByToken(token));
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void remove(EntityReference resource) {
        PersistentResourceToken token = this.get(resource);
        if (token.exists()) {
            this.tokenRepository.delete((IdentifiableEntity[])new PersistentResourceToken[]{token});
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void remove(String token) {
        PersistentResourceToken ptoken = this.get(token);
        if (ptoken.exists()) {
            this.tokenRepository.delete((IdentifiableEntity[])new PersistentResourceToken[]{ptoken});
        }
    }

    private PersistentResourceToken bind(PersistentResourceToken token) {
        if (token == null) {
            return PersistentResourceToken.NoneToken;
        }
        return token;
    }
}

