/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.silverpeas.core.security.authentication.password.PasswordEncryption;
import org.silverpeas.core.security.authentication.password.encryption.UnixSHA512Encryption;
import org.silverpeas.core.util.ServiceProvider;

public class PasswordEncryptionProvider {
    public static PasswordEncryption getDefaultPasswordEncryption() {
        return (PasswordEncryption)ServiceProvider.getService(UnixSHA512Encryption.class, (Annotation[])new Annotation[0]);
    }

    public static PasswordEncryption getPasswordEncryption(String digest) throws IllegalArgumentException {
        Set availableEncrypts = ServiceProvider.getAllServices(PasswordEncryption.class, (Annotation[])new Annotation[0]);
        PasswordEncryption encryption = availableEncrypts.stream().filter(encrypt -> encrypt.doUnderstandDigest(digest)).findFirst().orElseThrow(() -> new IllegalArgumentException("Digest '" + digest + "' not understand by any of the available encryption in Silverpeas"));
        return encryption;
    }

    private PasswordEncryptionProvider() {
    }
}

