/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.smtp;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.text.StringEscapeUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.MailSending;
import org.silverpeas.core.notification.user.AttachmentLink;
import org.silverpeas.core.notification.user.client.NotificationParameterNames;
import org.silverpeas.core.notification.user.client.NotificationTemplateKey;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.channel.AbstractListener;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.MailSettings;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="CHANNEL='SMTP'"), @ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/queue/notificationsQueue")}, description="Message driven bean to send notifications by email")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SMTPListener
extends AbstractListener
implements MessageListener {
    @Inject
    private Administration admin;

    public void onMessage(Message msg) {
        try {
            this.processMessage(msg);
        }
        catch (NotificationServerException e) {
            SilverLogger.getLogger((Object)this).error("JMS message processing error: message = {0}, Payload = {1}", (Object[])new String[]{msg.toString(), this.payLoad}, (Throwable)((Object)e));
        }
    }

    @Override
    public void send(NotificationData notification) throws NotificationServerException {
        List<AttachmentLink> attachments;
        Map keyValue = notification.getTargetParam();
        String tmpFromString = (String)keyValue.get(NotificationParameterNames.FROM.toString());
        Object tmpSubjectString = StringEscapeUtils.unescapeHtml4((String)keyValue.getOrDefault(NotificationParameterNames.SUBJECT.toString(), ""));
        String serverUrl = (String)keyValue.get(NotificationParameterNames.SERVERURL.toString());
        String baseServerUrl = (String)keyValue.get(NotificationParameterNames.SERVER_BASEURL.toString());
        String tmpUrlString = (String)keyValue.get(NotificationParameterNames.URL.toString());
        String linkLabel = (String)keyValue.get(NotificationParameterNames.LINKLABEL.toString());
        String tmpLanguageString = (String)keyValue.get(NotificationParameterNames.LANGUAGE.toString());
        String tmpAttachmentIdString = (String)keyValue.get(NotificationParameterNames.ATTACHMENTID.toString());
        String tmpSourceString = (String)keyValue.get(NotificationParameterNames.SOURCE.toString());
        Boolean hideSmtpHeaderFooter = (Boolean)keyValue.get(NotificationParameterNames.HIDESMTPHEADERFOOTER.toString());
        if (StringUtil.isDefined((String)tmpSourceString)) {
            tmpSubjectString = tmpSourceString + " : " + (String)tmpSubjectString;
        }
        if (tmpLanguageString == null) {
            tmpLanguageString = I18NHelper.DEFAULT_LANGUAGE;
        }
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationserver.channel.smtp.multilang.smtpBundle", (String)tmpLanguageString);
        if (tmpFromString == null) {
            throw new NotificationServerException("Missing sender email address!", new String[0]);
        }
        StringBuilder body2 = new StringBuilder();
        SilverpeasTemplate templateHeaderFooter = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"notification");
        templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_BASE_SERVER_URL.toString(), (Object)baseServerUrl);
        templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_SERVER_URL.toString(), (Object)serverUrl);
        templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_SENDER_NAME.toString(), (Object)notification.getSenderName());
        templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_SENDER_EMAIL.toString(), (Object)tmpFromString);
        if (hideSmtpHeaderFooter == null) {
            String smtpMessageheader = templateHeaderFooter.applyFileTemplate("SMTPmessageHeader_" + tmpLanguageString);
            body2.append(smtpMessageheader);
        }
        String messageBody = notification.getMessage();
        messageBody = WebEncodeHelper.convertBlanksForHtml((String)(messageBody + "\n\n"));
        body2.append(messageBody);
        if (tmpUrlString != null) {
            templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_LINK.toString(), (Object)tmpUrlString);
            if (StringUtil.isDefined((String)linkLabel)) {
                templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_LINK_LABEL.toString(), (Object)linkLabel);
            } else {
                templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_LINK_LABEL.toString(), (Object)messages.getString("GoToContribution"));
            }
        }
        if (!(attachments = this.getAttachmentLinks(keyValue, tmpLanguageString)).isEmpty()) {
            templateHeaderFooter.setAttribute(NotificationTemplateKey.NOTIFICATION_ATTACHMENTS.toString(), attachments);
        }
        StringBuilder beforeFooterMessage = new StringBuilder();
        StringBuilder afterFooterMessage = new StringBuilder();
        if (hideSmtpHeaderFooter == null) {
            this.applyFooterTemplate(templateHeaderFooter, tmpLanguageString, beforeFooterMessage, afterFooterMessage);
        }
        String bodyAsString = body2.toString();
        bodyAsString = bodyAsString.replace("<!--BEFORE_MESSAGE_FOOTER-->", beforeFooterMessage.toString().replaceAll("[\\n\\r]", ""));
        bodyAsString = bodyAsString.replace("<!--AFTER_MESSAGE_FOOTER-->", afterFooterMessage.toString().replaceAll("[\\n\\r]", ""));
        boolean isHtml = tmpAttachmentIdString == null;
        this.sendEmail(tmpFromString, notification.getSenderName(), notification.getTargetReceipt(), (String)tmpSubjectString, bodyAsString, isHtml);
    }

    private void applyFooterTemplate(SilverpeasTemplate templateHeaderFooter, String tmpLanguageString, StringBuilder beforeFooterMessage, StringBuilder afterFooterMessage) {
        String smtpMessageBeforeFooter = templateHeaderFooter.applyFileTemplate("SMTPmessageFooter_before_" + tmpLanguageString);
        beforeFooterMessage.append(smtpMessageBeforeFooter);
        String smtpMessageAfterFooter = templateHeaderFooter.applyFileTemplate("SMTPmessageFooter_after_" + tmpLanguageString);
        afterFooterMessage.append(smtpMessageAfterFooter);
    }

    private List<AttachmentLink> getAttachmentLinks(Map<String, Object> keyValues, String language) {
        List<AttachmentLink> links;
        String componentId = (String)keyValues.get(NotificationParameterNames.COMPONENTID.toString());
        String contributionId = (String)keyValues.get(NotificationParameterNames.ATTACHMENT_TARGETID.toString());
        if (StringUtil.isDefined((String)componentId) && StringUtil.isDefined((String)contributionId)) {
            ResourceReference ref = new ResourceReference(contributionId, componentId);
            links = AttachmentLink.getForContribution(ref, language);
        } else {
            links = Collections.emptyList();
        }
        return links;
    }

    private void sendEmail(String from, String fromName, String to, String subject, String content, boolean isHtml) throws NotificationServerException {
        boolean isSilverpeasEmail = Administration.get().getSilverpeasEmail().equals(from);
        MailAddress fromMailAddress = MailAddress.eMail(from).withName(Optional.ofNullable(fromName).filter(StringUtil::isDefined).orElseGet(() -> isSilverpeasEmail ? this.admin.getSilverpeasName() : ""));
        MailSending mail = MailSending.from(fromMailAddress).to(MailAddress.eMail(to)).withSubject(subject);
        try {
            InternetAddress fromAddress = fromMailAddress.getAuthorizedInternetAddress();
            if (!(isSilverpeasEmail || fromAddress.getAddress().equals(from) && !MailSettings.isForceReplyToSenderField())) {
                mail.setReplyToRequired();
            }
            if (isHtml) {
                mail.withContent(content);
            } else {
                mail.withTextContent(content);
            }
            mail.sendSynchronously();
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new NotificationServerException(e);
        }
    }
}

