/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.popup;

import java.lang.annotation.Annotation;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPException;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPMessage;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPMessageBean;
import org.silverpeas.core.notification.user.server.channel.popup.POPUPMessageBeanRepository;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.LongText;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

public class POPUPPersistence {
    protected static POPUPMessageBeanRepository getRepository() {
        return (POPUPMessageBeanRepository)((Object)ServiceProvider.getService(POPUPMessageBeanRepository.class, (Annotation[])new Annotation[0]));
    }

    public static void addMessage(POPUPMessage popupMsg) throws POPUPException {
        POPUPMessageBean smb = new POPUPMessageBean();
        if (popupMsg != null) {
            try {
                smb.setUserId(popupMsg.getUserId());
                smb.setSenderId(popupMsg.getSenderId());
                smb.setSenderName(popupMsg.getSenderName());
                smb.setBody(Integer.toString(LongText.addLongText((String)popupMsg.getBody())));
                smb.setAnswerAllowed(popupMsg.isAnswerAllowed());
                smb.setUrl(popupMsg.getUrl());
                smb.setSource(popupMsg.getSource());
                smb.setMsgDate(popupMsg.getDate());
                smb.setMsgTime(popupMsg.getTime());
                Transaction.performInOne(() -> (POPUPMessageBean)POPUPPersistence.getRepository().save((IdentifiableEntity)smb));
            }
            catch (Exception e) {
                throw new POPUPException("POPUPPersistence.addMessage()", 4, "POPUP.EX_CANT_WRITE_MESSAGE", e);
            }
        }
    }

    public static POPUPMessage getMessage(long msgId) throws POPUPException {
        POPUPMessage result;
        block4: {
            result = null;
            IdPK pk = new IdPK();
            try {
                pk.setIdAsLong(msgId);
                POPUPMessageBean smb = (POPUPMessageBean)POPUPPersistence.getRepository().getById(String.valueOf(msgId));
                if (smb == null) break block4;
                String body2 = "";
                result = new POPUPMessage();
                result.setId(Long.parseLong(smb.getId()));
                result.setUserId(smb.getUserId());
                result.setUserLogin(POPUPPersistence.getUserLogin(smb.getUserId()));
                result.setSenderId(smb.getSenderId());
                result.setSenderName(smb.getSenderName());
                try {
                    int longTextId = -1;
                    longTextId = Integer.parseInt(smb.getBody());
                    body2 = LongText.getLongText((int)longTextId);
                }
                catch (Exception e) {
                    SilverLogger.getLogger(POPUPPersistence.class).error((Throwable)e);
                    body2 = smb.getBody();
                }
                result.setBody(body2);
                result.setAnswerAllowed(smb.getAnswerAllowed());
                result.setUrl(smb.getUrl());
                result.setSource(smb.getSource());
                result.setDate(smb.getMsgDate());
                result.setTime(smb.getMsgTime());
            }
            catch (Exception e) {
                throw new POPUPException("POPUPPersistence.getMessage()", 4, "POPUP.EX_CANT_READ_MSG", "MsgId=" + Long.toString(msgId), e);
            }
        }
        return result;
    }

    public static void deleteMessage(long msgId) throws POPUPException {
        try {
            Transaction.performInOne(() -> {
                POPUPMessageBeanRepository repository = POPUPPersistence.getRepository();
                POPUPMessageBean toDel = (POPUPMessageBean)repository.getById(String.valueOf(msgId));
                if (toDel != null) {
                    try {
                        int longTextId = Integer.parseInt(toDel.getBody());
                        LongText.removeLongText((int)longTextId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    repository.delete((IdentifiableEntity[])new POPUPMessageBean[]{toDel});
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new POPUPException("POPUPPersistence.deleteMessage()", 4, "POPUP.EX_CANT_DEL_MSG", "MsgId=" + Long.toString(msgId), e);
        }
    }

    protected static String getUserLogin(long userId) throws POPUPException {
        String result = "";
        try {
            UserDetail ud = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(Long.toString(userId));
            if (ud != null) {
                result = ud.getLogin();
            }
        }
        catch (Exception e) {
            throw new POPUPException("POPUPPersistence.getUserLogin()", 4, "POPUP.EX_CANT_GET_USER_LOGIN", "UserId=" + Long.toString(userId), e);
        }
        return result;
    }
}

