/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.JMSOperation;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.NotificationServerUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class NotificationServer {
    private static final String JMS_HEADER_CHANNEL = "CHANNEL";
    @Resource(lookup="java:/jms/queue/notificationsQueue")
    private Queue queue;
    private Map<String, String> mJmsHeaders = new HashMap<String, String>();

    public static NotificationServer get() {
        return (NotificationServer)ServiceProvider.getService(NotificationServer.class, (Annotation[])new Annotation[0]);
    }

    private NotificationServer() {
    }

    public long addNotification(NotificationData pData) throws NotificationServerException {
        long notificationId = 0L;
        this.mJmsHeaders.clear();
        this.mJmsHeaders.put(JMS_HEADER_CHANNEL, pData.getTargetChannel());
        pData.setNotificationId(notificationId);
        String notificationAsXML = NotificationServerUtil.convertNotificationDataToXML(pData);
        try {
            this.jmsSendToQueue(notificationAsXML, this.mJmsHeaders);
        }
        catch (Exception e) {
            throw new NotificationServerException(e);
        }
        return notificationId;
    }

    private void jmsSendToQueue(String notificationMessage, Map<String, String> pJmsHeaders) {
        JMSOperation.realize(context -> {
            TextMessage textMsg = context.createTextMessage();
            textMsg.setText(notificationMessage);
            for (Map.Entry entry : pJmsHeaders.entrySet()) {
                textMsg.setStringProperty((String)entry.getKey(), (String)entry.getValue());
            }
            context.createProducer().send((Destination)this.queue, (Message)textMsg);
        });
    }
}

