/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.kernel.annotation.NonNull;

@Service
class ServerEventJobInitializer
extends SchedulingInitializer {
    private static final String JOB_NAME = "ServerEventJob";
    @Inject
    private Scheduler scheduler;
    private final Job job = new ServerEventCleanerJob();
    private final int sseAsyncJobTrigger = NotificationManagerSettings.getSseAsyncJobTrigger();

    ServerEventJobInitializer() {
    }

    protected JobTrigger getTrigger() {
        return JobTrigger.triggerEvery((int)this.sseAsyncJobTrigger, (TimeUnit)TimeUnit.SECOND);
    }

    @NonNull
    protected String getCron() {
        return "";
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return this.sseAsyncJobTrigger > 0;
    }

    private static class ServerEventCleanerJob
    extends Job {
        private ServerEventCleanerJob() {
            super(ServerEventJobInitializer.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            List asyncContexts = ServerEventDispatcherTask.getContextSnapshot();
            SseLogger.get().debug("doing quietly some stuffs over {0} {0,choice, 1#async context| 1<async contexts}", new Object[]{asyncContexts.size()});
            asyncContexts.forEach(SilverpeasServerEventContext::sendHeartbeatIfEnabled);
        }
    }
}

