/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
public class NodeProfileInstUpdater {
    @Inject
    private Administration admin;
    @Inject
    private NodeService nodeService;

    public Remover getRemoverFor(String componentInstanceId) {
        return new Remover(componentInstanceId);
    }

    public class Remover {
        private final String instanceId;
        private final Set<String> userIds = new HashSet<String>();
        private final Set<String> groupIds = new HashSet<String>();

        Remover(String instanceId) {
            this.instanceId = instanceId;
        }

        Remover ofUsers(Set<String> userIds) {
            this.userIds.clear();
            this.userIds.addAll(userIds);
            return this;
        }

        Remover ofGroups(Set<String> groupIds) {
            this.groupIds.clear();
            this.groupIds.addAll(groupIds);
            return this;
        }

        public void apply() {
            NodeProfileInstUpdater.this.nodeService.getDescendantDetails(new NodePK("0", this.instanceId)).stream().filter(NodeDetail::haveLocalRights).forEach(node -> this.getNodeRoles((NodeDetail)node).forEach(role -> {
                this.groupIds.stream().filter(group -> role.getAllGroups().contains(group)).filter(group -> this.isGroupNotPlayedAnyRole((String)group, this.instanceId)).forEach(group -> this.removeGroupFromRole((String)group, (ProfileInst)role));
                this.userIds.stream().filter(user -> role.getAllUsers().contains(user)).filter(user -> this.isUserNotPlayingAnotherRole((String)user, this.instanceId)).forEach(user -> this.removeUserFromRole((String)user, (ProfileInst)role));
            }));
        }

        private void removeUserFromRole(String userId, ProfileInst role) {
            try {
                role.removeUser(userId);
                NodeProfileInstUpdater.this.admin.updateProfileInst(role);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }

        private void removeGroupFromRole(String groupId, ProfileInst role) {
            try {
                role.removeGroup(groupId);
                NodeProfileInstUpdater.this.admin.updateProfileInst(role);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }

        private List<ProfileInst> getNodeRoles(NodeDetail node) {
            try {
                return NodeProfileInstUpdater.this.admin.getProfilesByObject(ProfiledObjectId.fromNode(node.getId()), node.getIdentifier().getComponentInstanceId());
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }

        private ProfileInst getProfileInst(String profileId) {
            try {
                return NodeProfileInstUpdater.this.admin.getProfileInst(profileId);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }

        private boolean isUserNotPlayingAnotherRole(String userId, String instanceId) {
            try {
                String[] roleNames = NodeProfileInstUpdater.this.admin.getCurrentProfiles(userId, instanceId);
                return roleNames.length == 0;
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }

        private boolean isGroupNotPlayedAnyRole(String groupId, String instanceId) {
            try {
                int localId = ComponentInst.getComponentLocalId(instanceId);
                return Stream.of(NodeProfileInstUpdater.this.admin.getProfileIdsOfGroup(groupId)).map(this::getProfileInst).filter(ProfileInst::isOnComponentInstance).noneMatch(p -> p.getComponentFatherId() == localId);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        }
    }
}

