/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.imagemagick;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.MogrifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.media.image.AbstractImageTool;
import org.silverpeas.core.io.media.image.ImageInfoType;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.imagemagick.Im4javaManager;
import org.silverpeas.core.io.media.image.option.AbstractImageToolOption;
import org.silverpeas.core.io.media.image.option.AnchoringPosition;
import org.silverpeas.core.io.media.image.option.BackgroundOption;
import org.silverpeas.core.io.media.image.option.CropOption;
import org.silverpeas.core.io.media.image.option.DimensionOption;
import org.silverpeas.core.io.media.image.option.Margins;
import org.silverpeas.core.io.media.image.option.Orientation;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.io.media.image.option.TransparencyColorOption;
import org.silverpeas.core.io.media.image.option.WatermarkImageOption;
import org.silverpeas.core.io.media.image.option.WatermarkTextOption;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;

@Service
public class Im4javaImageTool
extends AbstractImageTool {
    private static final String FIRST_PAGE_ONLY = "[0]";
    private static final String GEOMETRY_SHRINK = ">";

    @Override
    public boolean isActivated() {
        return Im4javaManager.isActivated();
    }

    @Override
    public String[] getImageInfo(File source, ImageInfoType ... infoTypes) throws SilverpeasException {
        return this.identify(source, (String[])Arrays.stream(infoTypes).map(ImageInfoType::getImOption).toArray(String[]::new));
    }

    private String[] identify(File source, String ... infoTypes) throws SilverpeasException {
        try {
            IMOperation op = new IMOperation();
            op.format(String.join((CharSequence)"|", infoTypes));
            op.addImage(new String[]{source.getPath()});
            IdentifyCmd identifyCmd = new IdentifyCmd();
            ArrayListOutputConsumer result = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer((OutputConsumer)result);
            identifyCmd.run((Operation)op, new Object[0]);
            return ((String)result.getOutput().get(0)).split("[|]");
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new SilverpeasException((Throwable)e);
        }
    }

    @Override
    protected void convert(File source, File destination, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) throws SilverpeasException {
        block9: {
            boolean sourceIsDestination = source.equals(destination);
            IMOperation op = new IMOperation();
            if (!sourceIsDestination) {
                this.setSource(op, source, directives);
            }
            try {
                this.orientation(op, source, options, directives);
                this.transparencyColor(op, options);
                this.background(op, options);
                this.crop(op, options, directives);
                this.resize(op, options, directives);
                this.watermarkText(op, source, options);
                this.watermarkImage(op, source, options);
                this.setDestination(op, destination);
                if (sourceIsDestination) {
                    new MogrifyCmd().run((Operation)op, new Object[0]);
                } else {
                    new ConvertCmd().run((Operation)op, new Object[0]);
                }
            }
            catch (NoWorkToDo e) {
                if (sourceIsDestination) break block9;
                try {
                    FileUtils.copyFile((File)source, (File)destination);
                }
                catch (IOException ex) {
                    throw new SilverpeasException((Throwable)ex);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new SilverpeasException((Throwable)e);
            }
        }
    }

    private void setSource(IMOperation op, File source, Set<ImageToolDirective> directives) {
        StringBuilder sb = new StringBuilder(source.getPath());
        if (directives.contains((Object)ImageToolDirective.FIRST_PAGE_ONLY)) {
            sb.append(FIRST_PAGE_ONLY);
        }
        op.addImage(new String[]{sb.toString()});
    }

    private void setDestination(IMOperation op, File destination) {
        op.addImage(new String[]{destination.getPath()});
    }

    private void background(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) {
        BackgroundOption background = this.getOption(options, BackgroundOption.class);
        if (background != null) {
            op.background(background.getValue());
            op.flatten();
        }
    }

    private void orientation(IMOperation op, File source, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) throws NoWorkToDo {
        OrientationOption option = this.getOption(options, OrientationOption.class);
        if (option != null) {
            this.checkIftImageMustBeProcessed(source, option, options, directives);
            if (option.getOrientation() == Orientation.AUTO) {
                op.autoOrient();
            } else {
                op.orient(option.getOrientation().getToolName());
            }
        }
    }

    private void checkIftImageMustBeProcessed(File source, OrientationOption option, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) throws NoWorkToDo {
        if (option.isModifyingImageOnlyIfNecessary() && options.size() == 1 && directives.isEmpty()) {
            Mutable currentOrientation = Mutable.empty();
            try {
                Stream.of(ImageTool.get().getImageInfo(source, ImageInfoType.ORIENTATION)).map(Orientation::decode).filter(Objects::nonNull).findFirst().ifPresent(arg_0 -> ((Mutable)currentOrientation).set(arg_0));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            if (!currentOrientation.isPresent() || option.getOrientation() == Orientation.AUTO && currentOrientation.get() == Orientation.TOP_LEFT || option.getOrientation() == currentOrientation.get()) {
                throw new NoWorkToDo();
            }
        }
    }

    private void transparencyColor(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) {
        TransparencyColorOption transparencyColor = this.getOption(options, TransparencyColorOption.class);
        if (transparencyColor != null) {
            op.transparentColor(transparencyColor.getColor());
        }
    }

    private void resize(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) {
        DimensionOption dimension = this.getOption(options, DimensionOption.class);
        if (dimension != null) {
            StringBuilder specialDirective = new StringBuilder();
            if (directives.contains((Object)ImageToolDirective.GEOMETRY_SHRINK)) {
                specialDirective.append(GEOMETRY_SHRINK);
            }
            if (directives.contains((Object)ImageToolDirective.PREVIEW_WORK)) {
                op.thumbnail(dimension.getWidth(), dimension.getHeight(), specialDirective.toString());
            } else {
                op.resize(dimension.getWidth(), dimension.getHeight(), specialDirective.toString());
            }
        }
    }

    private void crop(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) {
        CropOption crop = this.getOption(options, CropOption.class);
        if (crop != null) {
            StringBuilder specialDirective = new StringBuilder();
            if (directives.contains((Object)ImageToolDirective.GEOMETRY_SHRINK)) {
                specialDirective.append(GEOMETRY_SHRINK);
            }
            op.crop(crop.getWidth(), crop.getHeight(), crop.getOffsetX(), crop.getOffsetY(), specialDirective.toString());
            if (crop.mustRemovePartsAroundCroppedZone()) {
                op.p_repage();
            }
        }
    }

    private void watermarkText(IMOperation op, File source, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) throws SilverpeasException {
        WatermarkTextOption watermarkText = this.getOption(options, WatermarkTextOption.class);
        if (watermarkText != null) {
            Integer[] imageInfo = this.getWidthAndHeight(source, options, false);
            int width = imageInfo[0];
            int height = imageInfo[1];
            int[] margins = this.computeMargins(width, 0.01, height, 0.1, watermarkText);
            int pointSize = (int)Math.rint((double)width * 0.02 + Math.log(width));
            pointSize = Math.min((int)((double)height * 0.2), pointSize);
            int minX = margins[0];
            int minY = margins[1];
            int x = (int)((double)minX + Math.max(1.0, (double)pointSize / 2.5));
            int y = (int)((double)minY + Math.max(1.0, (double)pointSize / 1.75));
            String text = watermarkText.getText();
            AnchoringPosition anchoringPosition = watermarkText.getAnchoringPosition();
            op.font(watermarkText.getFont());
            op.pointsize(Integer.valueOf(pointSize));
            String black = "rgba(0, 0, 0, 0.5)";
            String white = "rgba(255, 255, 255, 0.5)";
            this.drawText(op, black, text, anchoringPosition, x, y);
            this.drawText(op, white, text, anchoringPosition, minX, minY);
        }
    }

    private void drawText(IMOperation op, String color, String text, AnchoringPosition anchoringPosition, int x, int y) {
        String drawSb = "gravity " + anchoringPosition.getToolName() + " fill " + color + " text " + x + "," + y + " '" + text.replace("'", "\\'") + "'";
        op.draw(drawSb);
    }

    private void watermarkImage(IMOperation op, File source, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) throws SilverpeasException {
        WatermarkImageOption watermarkImage = this.getOption(options, WatermarkImageOption.class);
        if (watermarkImage != null) {
            AnchoringPosition anchoringPosition;
            int widthFromHeight;
            Integer[] srcInfo = this.getWidthAndHeight(source, options, false);
            int srcWidth = srcInfo[0];
            int srcHeight = srcInfo[1];
            int[] margins = this.computeMargins(srcWidth, 0.01, srcHeight, 0.1, watermarkImage);
            int marginX = margins[0];
            int marginY = margins[1];
            srcWidth -= marginX * 2;
            srcHeight -= marginY * 2;
            File watermark = watermarkImage.getImage();
            Integer[] wInfo = this.getWidthAndHeight(watermark, options, true);
            float wWidth = wInfo[0].intValue();
            float wHeight = wInfo[1].intValue();
            int width = 0;
            int height = 0;
            if ((float)srcWidth < wWidth) {
                width = srcWidth;
                height = Math.round((float)srcWidth / (wWidth / wHeight));
            }
            if ((float)srcHeight < wHeight && (widthFromHeight = Math.round((float)srcHeight * (wWidth / wHeight))) < srcWidth) {
                width = widthFromHeight;
                height = srcHeight;
            }
            if ((anchoringPosition = watermarkImage.getAnchoringPosition()) == AnchoringPosition.TILE) {
                op.tile();
            } else {
                op.gravity(anchoringPosition.getToolName());
            }
            op.draw(MessageFormat.format("image {0} {1},{2} {3},{4} ''{5}''", watermarkImage.getCompositionOperation().getToolName(), String.valueOf(marginX), String.valueOf(marginY), String.valueOf(width), String.valueOf(height), watermark.getPath()));
        }
    }

    private int[] computeMargins(int width, double wFactor, int height, double hFactor, Margins margins) {
        int marginOffset = (int)Math.rint((double)width * wFactor + Math.log(width));
        marginOffset = Math.min((int)((double)height * hFactor), marginOffset);
        int marginX = margins.getMarginX() != null ? margins.getMarginX() : marginOffset;
        int marginY = margins.getMarginY() != null ? margins.getMarginY() : marginOffset;
        return new int[]{marginX, marginY};
    }

    private Integer[] getWidthAndHeight(File source, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, boolean skipOptions) throws SilverpeasException {
        DimensionOption dimension;
        ImageInfoType[] imageInfoTypeArray;
        Orientation orientation = Orientation.decode(this.getImageInfo(source, ImageInfoType.ORIENTATION)[0]);
        if (skipOptions || orientation == null || orientation.ordinal() <= 3) {
            ImageInfoType[] imageInfoTypeArray2 = new ImageInfoType[2];
            imageInfoTypeArray2[0] = ImageInfoType.WIDTH_IN_PIXEL;
            imageInfoTypeArray = imageInfoTypeArray2;
            imageInfoTypeArray2[1] = ImageInfoType.HEIGHT_IN_PIXEL;
        } else {
            ImageInfoType[] imageInfoTypeArray3 = new ImageInfoType[2];
            imageInfoTypeArray3[0] = ImageInfoType.HEIGHT_IN_PIXEL;
            imageInfoTypeArray = imageInfoTypeArray3;
            imageInfoTypeArray3[1] = ImageInfoType.WIDTH_IN_PIXEL;
        }
        ImageInfoType[] imageInfoTypes = imageInfoTypeArray;
        Integer[] imageInfo = (Integer[])Stream.of(this.getImageInfo(source, imageInfoTypes)).map(Integer::parseInt).toArray(Integer[]::new);
        DimensionOption dimensionOption = dimension = skipOptions ? null : this.getOption(options, DimensionOption.class);
        if (dimension != null) {
            int width = imageInfo[0];
            int height = imageInfo[1];
            float ratio = (float)width / (float)height;
            if (dimension.getWidth() != null && dimension.getWidth() < width) {
                width = dimension.getWidth();
                height = Math.round((float)dimension.getWidth().intValue() / ratio);
            }
            if (dimension.getHeight() != null && dimension.getHeight() < height) {
                width = Math.round((float)dimension.getHeight().intValue() * ratio);
                height = dimension.getHeight();
            }
            imageInfo[0] = width;
            imageInfo[1] = height;
        }
        return imageInfo;
    }

    private static class NoWorkToDo
    extends Exception {
        private static final long serialVersionUID = -3695880835319345867L;

        private NoWorkToDo() {
        }
    }
}

