/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.file.AbstractSilverpeasFileProcessor;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProcessor;
import org.silverpeas.core.util.StringDataExtractor;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class AttachmentUrlLinkProcessor
extends AbstractSilverpeasFileProcessor {
    private static final int PRIORITY = 80;
    private static final List<Pattern> ATTACHMENT_ID_FROM_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)/attachmentId/([a-z\\-0-9]+)/"), Pattern.compile("(?i)/File/([a-z\\-0-9]+)"));
    private static final List<Pattern> ATTACHMENT_LANG_FROM_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)/lang/([a-z]+)/"), Pattern.compile("(?i)ContentLanguage=([a-z]+)"));
    private static final Pattern SIZE_DIRECTIVE_FROM_LINK = Pattern.compile("(?i)/size/([0-9 x]+)");

    @Override
    public String processBefore(String attachmentLink, SilverpeasFileProcessor.ProcessingContext context) {
        if (context == SilverpeasFileProcessor.ProcessingContext.GETTING && attachmentLink.contains(URLUtil.getApplicationURL())) {
            String attachmentId = StringDataExtractor.from(attachmentLink).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_ID_FROM_LINK_PATTERNS, 1)).extractUnique();
            if (!StringUtil.isDefined((String)attachmentId)) {
                return attachmentLink;
            }
            String contentLanguage = StringDataExtractor.from(attachmentLink).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_LANG_FROM_LINK_PATTERNS, 1)).extractUnique();
            contentLanguage = I18NHelper.checkLanguage(contentLanguage);
            SimpleDocumentPK sdPK = new SimpleDocumentPK(attachmentId);
            SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(sdPK, contentLanguage);
            if (attachment == null) {
                return SilverpeasFile.NO_FILE.getPath();
            }
            String specifiedSize = StringDataExtractor.from(attachmentLink).withDirective(StringDataExtractor.RegexpPatternDirective.regexp(SIZE_DIRECTIVE_FROM_LINK, 1)).extractUnique();
            File attachmentFile = new File(attachment.getAttachmentPath());
            if (StringUtil.isDefined((String)specifiedSize)) {
                attachmentFile = FileUtils.getFile((File)attachmentFile.getParentFile(), (String[])new String[]{specifiedSize, attachmentFile.getName()});
            }
            return attachmentFile.getPath();
        }
        return attachmentLink;
    }

    @Override
    public SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        return file;
    }

    @Override
    public int getPriority() {
        return 80;
    }
}

