/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.admin.domain.model.DomainProperties;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.search.PlainSearchResult;
import org.silverpeas.core.index.search.SearchEngine;
import org.silverpeas.core.index.search.model.DidYouMeanSearcher;
import org.silverpeas.core.index.search.model.IndexSearcher;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.ParseException;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchCompletion;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAuthorization;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class SimpleSearchEngine
implements SearchEngine {
    private static final List<String> EXTERNAL_CONTRIBUTION_TYPE = List.of("Versioning", "Publication", "Node");
    private static final Function<FilterMatchingIndexEntryItem, ComponentAuthorization.ComponentResourceReference> itemAsContributionIdentifier = i -> {
        MatchingIndexEntry mie = i.getEntry();
        String id = mie.isLinkedObject() ? mie.getLinkedObjectId() : mie.getObjectId();
        return new ComponentAuthorization.ComponentResourceReference(id, mie.getObjectType(), mie.getComponent());
    };
    @Inject
    private DidYouMeanSearcher didYouMeanSearcher;
    @Inject
    private IndexSearcher indexSearcher;
    @Inject
    private OrganizationController organization;
    private final SettingBundle pdcSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.pdcPeas.settings.pdcPeasSettings");
    private final float minScore = this.pdcSettings.getFloat("wordSpellingMinScore", 0.5f);
    private final boolean enableWordSpelling = this.pdcSettings.getBoolean("enableWordSpelling", false);
    private final String localServerName = this.pdcSettings.getString("server.name");

    private SimpleSearchEngine() {
    }

    @Override
    public PlainSearchResult search(QueryDescription query) throws ParseException {
        try {
            String[] suggestions;
            List<MatchingIndexEntry> results = Arrays.asList(this.indexSearcher.search(query));
            if (!query.isAdminScope()) {
                long startTime = System.currentTimeMillis();
                results = this.filterMatchingIndexEntries(results, query.getSearchingUser());
                long endTime = System.currentTimeMillis();
                int nbResultItemsAfterFiltering = results.size();
                SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format(" search index filtering duration in {0} and keeping {1} entries", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), nbResultItemsAfterFiltering));
            }
            Set spellingWords = Collections.emptySet();
            if (this.enableWordSpelling && this.isSpellingNeeded(results) && (suggestions = this.didYouMeanSearcher.suggest(query)) != null && suggestions.length > 0) {
                spellingWords = new HashSet(suggestions.length);
                Collections.addAll(spellingWords, suggestions);
            }
            return new PlainSearchResult(new ArrayList<String>(spellingWords), results);
        }
        catch (IOException ioex) {
            throw new ParseException("SimpleSearchEngine.search", ioex);
        }
    }

    private boolean isSpellingNeeded(List<MatchingIndexEntry> results) {
        for (MatchingIndexEntry match : results) {
            if (!(this.minScore < match.getScore())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> suggestKeywords(String keywordFragment) {
        SearchCompletion completion = new SearchCompletion();
        return completion.getSuggestions(keywordFragment);
    }

    private List<MatchingIndexEntry> filterMatchingIndexEntries(List<MatchingIndexEntry> matchingIndexEntries, String userId) {
        if (matchingIndexEntries == null || matchingIndexEntries.isEmpty()) {
            return new ArrayList<MatchingIndexEntry>();
        }
        Set allowedComponentIds = StringUtil.isDefined((String)userId) ? Stream.of(this.organization.getAvailCompoIds(userId)).collect(Collectors.toSet()) : Collections.emptySet();
        List<FilterMatchingIndexEntryItem> filterItems = matchingIndexEntries.stream().map(x$0 -> new FilterMatchingIndexEntryItem((MatchingIndexEntry)x$0)).collect(Collectors.toList());
        boolean enableExternalSearch = this.pdcSettings.getBoolean("external.search.enable", false);
        List<FilterMatchingIndexEntryItem> nonProcessedItems = this.removeExternalEntries(filterItems, enableExternalSearch);
        Iterator it = ComponentAuthorization.getAll().iterator();
        while (it.hasNext() && !nonProcessedItems.isEmpty()) {
            ComponentAuthorization componentAuthorization = (ComponentAuthorization)it.next();
            nonProcessedItems = this.checkAccessAuthorization(userId, nonProcessedItems, componentAuthorization);
        }
        return filterItems.stream().filter(r -> this.isMatchingIndexEntryAvailable((FilterMatchingIndexEntryItem)r, userId, allowedComponentIds)).map(FilterMatchingIndexEntryItem::getEntry).collect(Collectors.toList());
    }

    @Nonnull
    private List<FilterMatchingIndexEntryItem> checkAccessAuthorization(String userId, List<FilterMatchingIndexEntryItem> items, ComponentAuthorization componentAuthorization) {
        ArrayList processedItems = new ArrayList(items.size());
        List<FilterMatchingIndexEntryItem> nonRelatedItems = items.stream().filter(i -> {
            boolean relatedTo = componentAuthorization.isRelatedTo(i.getEntry().getComponent());
            if (relatedTo) {
                i.processed();
                processedItems.add(i);
            }
            return !relatedTo;
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(processedItems)) {
            componentAuthorization.filter(processedItems, itemAsContributionIdentifier, userId, new AccessControlOperation[]{AccessControlOperation.SEARCH}).forEach(FilterMatchingIndexEntryItem::keep);
        }
        return nonRelatedItems;
    }

    @Nonnull
    private List<FilterMatchingIndexEntryItem> removeExternalEntries(List<FilterMatchingIndexEntryItem> filterItems, boolean enableExternalSearch) {
        return filterItems.stream().map(i -> Optional.of(i.getEntry()).filter(e -> enableExternalSearch && this.isExternalComponent(e.getServerName())).map(e -> {
            i.processed();
            e.setExternalResult(true);
            String objectType = e.getObjectType();
            if (EXTERNAL_CONTRIBUTION_TYPE.contains(objectType)) {
                i.keep();
            }
            return i;
        }).orElse((FilterMatchingIndexEntryItem)i)).filter(Predicate.not(FilterMatchingIndexEntryItem::isProcessed)).collect(Collectors.toList());
    }

    private boolean isMatchingIndexEntryAvailable(FilterMatchingIndexEntryItem item, String userId, Set<String> allowedComponentIds) {
        if (item.isProcessed()) {
            return item.isToKeep();
        }
        return this.isOtherItemAvailable(item.getEntry(), userId, allowedComponentIds);
    }

    private boolean isOtherItemAvailable(MatchingIndexEntry mie, String userId, Set<String> allowedComponentIds) {
        String objectType = mie.getObjectType();
        if ("Space".equals(objectType)) {
            return this.isSpaceVisible(mie.getObjectId(), userId);
        }
        if ("Component".equals(objectType)) {
            return this.isComponentVisible(mie.getComponent(), allowedComponentIds);
        }
        if ("UserFull".equals(objectType)) {
            return this.isUserVisible(mie.getObjectId());
        }
        return true;
    }

    private boolean isSpaceVisible(String spaceId, String userId) {
        try {
            return Administration.get().isSpaceAvailable(userId, spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn("Can't test if space {0} is available for user {1}", new Object[]{new String[]{spaceId, userId}, e});
            return false;
        }
    }

    private boolean isComponentVisible(String appId, Set<String> allowedComponentIds) {
        return allowedComponentIds.contains(appId);
    }

    private boolean isUserVisible(String userId) {
        User userFound = User.getById((String)userId);
        if (DomainProperties.areDomainsVisibleOnlyToDefaultOne()) {
            String currentUserDomainId = User.getById((String)userId).getDomainId();
            if ("0".equals(currentUserDomainId)) {
                return true;
            }
            return userFound.getDomainId().equals(currentUserDomainId);
        }
        if (DomainProperties.areDomainsNonVisibleToOthers()) {
            String currentUserDomainId = User.getById((String)userId).getDomainId();
            return userFound.getDomainId().equals(currentUserDomainId);
        }
        return true;
    }

    private boolean isExternalComponent(String serverName) {
        return StringUtil.isDefined((String)this.localServerName) && !this.localServerName.equalsIgnoreCase(serverName);
    }

    private static class FilterMatchingIndexEntryItem {
        private final MatchingIndexEntry entry;
        private boolean processed = false;
        private boolean toKeep = false;

        private FilterMatchingIndexEntryItem(MatchingIndexEntry entry) {
            this.entry = entry;
        }

        MatchingIndexEntry getEntry() {
            return this.entry;
        }

        void processed() {
            this.processed = true;
        }

        boolean isProcessed() {
            return this.processed;
        }

        public void keep() {
            this.toKeep = true;
        }

        boolean isToKeep() {
            return this.toKeep;
        }
    }
}

