/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class IndexEngineInitialize
implements Initialization {
    public void init() {
        String indexPath = ResourceLocator.getGeneralSettingBundle().getString("uploadsIndexPath");
        String removeLocks = ResourceLocator.getGeneralSettingBundle().getString("removeLocksOnInit", "");
        if (StringUtil.getBooleanValue((String)removeLocks)) {
            String property = System.getProperty("java.io.tmpdir");
            this.removeLockFiles(new File(property));
            this.removeLockFiles(new File(indexPath));
        }
    }

    protected void removeLockFiles(File theFile) {
        block4: {
            block3: {
                if (!theFile.isDirectory()) break block3;
                File[] list = theFile.listFiles();
                int i = 0;
                while (list != null && i < list.length) {
                    this.removeLockFiles(list[i++]);
                }
                break block4;
            }
            if (!theFile.isFile() || !this.isLockFile(theFile.getName())) break block4;
            try {
                Files.delete(theFile.toPath());
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).error("Cannot delete file " + theFile.getPath(), new Object[0]);
            }
        }
    }

    protected boolean isLockFile(String fileName) {
        return fileName.startsWith("lucene-") || "write.lock".equalsIgnoreCase(fileName);
    }
}

