/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.i18n;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.Nameable;
import org.silverpeas.core.i18n.BeanTranslation;
import org.silverpeas.core.i18n.I18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractI18NBean<T extends BeanTranslation>
implements Serializable,
Nameable,
I18NBean<T> {
    private static final long serialVersionUID = 756146888448232764L;
    @XmlElement(namespace="http://www.silverpeas.org/exchange")
    private String name = "";
    @XmlElement(namespace="http://www.silverpeas.org/exchange")
    private String description = "";
    private String language = I18NHelper.DEFAULT_LANGUAGE;
    private String translationId = null;
    private transient Map<String, T> translations = new HashMap<String, T>(3);
    private boolean removeTranslation = false;

    protected AbstractI18NBean() {
    }

    protected AbstractI18NBean(AbstractI18NBean<T> other) {
        this.name = other.name;
        this.description = other.description;
        this.language = other.language;
        this.translationId = other.translationId;
        this.translations.putAll(other.translations);
        this.removeTranslation = other.removeTranslation;
    }

    private T getDefaultTranslation() {
        String lang = this.getLanguage();
        Class<T> type = this.getTranslationType();
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.trySetAccessible();
            BeanTranslation translation = (BeanTranslation)constructor.newInstance(new Object[0]);
            translation.setName(this.name);
            translation.setDescription(this.description);
            translation.setLanguage(lang);
            translation.setId(this.translationId);
            this.translations.put(lang, translation);
            return (T)translation;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    protected abstract Class<T> getTranslationType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        String lang = this.getLanguage();
        T translation = this.getTranslation(lang);
        ((BeanTranslation)translation).setName(name);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
        String lang = this.getLanguage();
        T translation = this.getTranslation(lang);
        ((BeanTranslation)translation).setDescription(description);
    }

    public String getName(String language) {
        T translation = this.selectTranslation(language);
        return ((BeanTranslation)translation).getName();
    }

    public String getDescription(String language) {
        T translation = this.selectTranslation(language);
        return ((BeanTranslation)translation).getDescription();
    }

    private T selectTranslation(String language) {
        String lang = StringUtil.isDefined((String)language) ? language : I18NHelper.DEFAULT_LANGUAGE;
        BeanTranslation translation = (BeanTranslation)this.getTranslations().get(lang);
        if (translation == null) {
            translation = this.getNextTranslation();
        }
        return (T)translation;
    }

    public String getLanguage() {
        if (I18NHelper.isI18nContentActivated && StringUtil.isNotDefined((String)this.language)) {
            return I18NHelper.DEFAULT_LANGUAGE;
        }
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = StringUtil.isDefined((String)language) ? language : I18NHelper.DEFAULT_LANGUAGE;
    }

    public boolean isRemoveTranslation() {
        return this.removeTranslation;
    }

    @Override
    public void setRemoveTranslation(boolean removeTranslation) {
        this.removeTranslation = removeTranslation;
    }

    public String getTranslationId() {
        return this.translationId;
    }

    @Override
    public void setTranslationId(String translationId) {
        this.translationId = translationId;
    }

    public Collection<String> getLanguages() {
        return Set.copyOf(this.translations.keySet());
    }

    @Override
    public Map<String, T> getTranslations() {
        return Map.copyOf(this.translations);
    }

    public Map<String, T> getClonedTranslations() {
        return this.translations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BeanTranslation)e.getValue()).copy()));
    }

    public void setTranslations(Map<String, T> translations) {
        this.translations = translations;
    }

    public void setTranslations(Collection<T> translations) {
        if (translations != null && !translations.isEmpty()) {
            translations.forEach(this::addTranslation);
        }
    }

    public T getTranslation(String language) {
        return this.selectTranslation(language);
    }

    public void addTranslation(T translation) {
        String lang = ((BeanTranslation)translation).getLanguage();
        if (!StringUtil.isDefined((String)lang)) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
            ((BeanTranslation)translation).setLanguage(lang);
        }
        this.translations.put(lang, translation);
    }

    @Override
    public T getNextTranslation() {
        Map<String, T> l10n = this.getTranslations();
        return (T)I18NHelper.getLanguages().stream().map(l10n::get).filter(Objects::nonNull).findFirst().orElseGet(this::getDefaultTranslation);
    }

    public String getLanguageToDisplay(String language) {
        String languageToDisplay = language;
        T translation = this.getTranslation(language);
        if (translation == null && (translation = this.getNextTranslation()) != null) {
            languageToDisplay = ((BeanTranslation)translation).getLanguage();
        }
        return languageToDisplay;
    }
}

