/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.rating.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.RaterRatingPK;
import org.silverpeas.core.contribution.rating.model.Rating;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.util.SilverpeasList;

@Repository
public class RatingRepository
extends BasicJpaEntityRepository<Rating> {
    public void deleteAllRatingsOfAContribution(ContributionRatingPK contribution) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add("contributionId", (Object)contribution.getId()).add("instanceId", (Object)contribution.getInstanceId()).add("contributionType", (Object)contribution.getContributionType());
        this.deleteFromNamedQuery("deleteAllByContribution", parameters);
    }

    public void deleteAllRatingsInComponentInstance(String instanceId) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add("instanceId", (Object)instanceId);
        this.deleteFromNamedQuery("deleteByInstanceId", parameters);
    }

    public Rating getRating(RaterRatingPK raterRating) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add("contributionId", (Object)raterRating.getId()).add("instanceId", (Object)raterRating.getInstanceId()).add("contributionType", (Object)raterRating.getContributionType()).add("authorId", (Object)raterRating.getRater().getId());
        return (Rating)this.getFromNamedQuery("findByAuthorRating", parameters);
    }

    public Map<String, ContributionRating> getAllRatingByContributions(String instanceId, String contributionType, String ... contributionIds) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add("instanceId", (Object)instanceId).add("contributionType", (Object)contributionType).add("contributionIds", Arrays.asList(contributionIds));
        SilverpeasList ratings = this.findByNamedQuery("findByContributions", parameters);
        HashMap<String, ContributionRating> ratingsByContribution = new HashMap<String, ContributionRating>(ratings.size());
        for (Rating rating : ratings) {
            ContributionRating contributionRating = (ContributionRating)ratingsByContribution.get(rating.getContributionId());
            if (contributionRating == null) {
                contributionRating = new ContributionRating(new ContributionRatingPK(rating.getContributionId(), rating.getInstanceId(), rating.getContributionType()));
                ratingsByContribution.put(rating.getContributionId(), contributionRating);
            }
            contributionRating.addRaterRating(rating.getAuthorId(), rating.getNote());
        }
        return ratingsByContribution;
    }

    public void moveAllRatingsOfAContribution(ContributionRatingPK contribution, String instanceId) {
        NamedParameters parameters = this.newNamedParameters();
        parameters.add("contributionId", (Object)contribution.getId()).add("instanceId", (Object)contribution.getInstanceId()).add("contributionType", (Object)contribution.getContributionType()).add("newInstanceId", (Object)instanceId);
        this.updateFromNamedQuery("updateInstanceId", parameters);
    }
}

