/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.social;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.publication.social.SocialInformationPublication;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialPublicationProvider;

@Provider
public class SocialPublications
implements SocialPublicationProvider {
    @Inject
    private PublicationService publicationService;

    protected SocialPublications() {
    }

    @Override
    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        return this.getPublicationService().getAllPublicationsWithStatusbyUserid(userId, begin, end);
    }

    private PublicationService getPublicationService() {
        return this.publicationService;
    }

    @Override
    public List<SocialInformation> getSocialInformationListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "kmelia")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "toolbox")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "kmax")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "blog")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "quickinfo")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "bookmark")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "webSites")));
        List<SocialInformation> socialPublications = this.publicationService.getSocialInformationsListOfMyContacts(myContactsIds, instanceIds, begin, end);
        Iterator<SocialInformationPublication> socialPublicationIt = socialPublications.iterator();
        while (socialPublicationIt.hasNext()) {
            SocialInformationPublication socialPublication = socialPublicationIt.next();
            String instanceId = socialPublication.getPublication().getInstanceId();
            if (myId.equals(socialPublication.getAuthor()) || !instanceId.startsWith("kmelia") || PublicationAccessControl.get().isUserAuthorized(myId, new PublicationPK(socialPublication.getPublication().getId(), instanceId))) continue;
            socialPublicationIt.remove();
        }
        return socialPublications;
    }
}

