/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class PublicationSelection
extends ClipboardSelection
implements Serializable {
    private static final long serialVersionUID = -1169335280661356348L;
    public static final DataFlavor PublicationDetailFlavor = new DataFlavor(PublicationDetail.class, PublicationDetail.getResourceType());
    private final NodePK fatherPK;
    private final PublicationDetail pub;

    public PublicationSelection(PublicationDetail pub, NodePK fatherPK) {
        this.pub = pub;
        this.fatherPK = fatherPK;
        super.addFlavor(PublicationDetailFlavor);
    }

    @Override
    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (parFlavor.equals(PublicationDetailFlavor)) {
                transferedData = new TransferData(this.pub, this.fatherPK);
            }
            throw e;
        }
        return transferedData;
    }

    @Override
    public IndexEntry getIndexEntry() {
        PublicationPK pubPK = this.pub.getPK();
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(pubPK.getComponentName(), this.pub.getContributionType(), this.pub.getPK().getId()));
        indexEntry.setTitle(this.pub.getName());
        return indexEntry;
    }

    @Override
    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.pub.getId(), this.pub.getInstanceId());
        keyData.setTitle(this.pub.getName());
        keyData.setAuthor(this.pub.getCreatorId());
        keyData.setCreationDate(this.pub.getCreationDate());
        keyData.setDesc(this.pub.getDescription());
        keyData.setText(this.pub.getContentPagePath());
        keyData.setType(this.pub.getContributionType());
        keyData.setLink(URLUtil.getSimpleURL(2, this.pub.getId(), this.pub.getInstanceId()));
        try {
            if (this.pub.getBeginDate() != null) {
                keyData.setProperty("BEGINDATE", this.pub.getBeginDate().toString());
            }
            if (this.pub.getEndDate() != null) {
                keyData.setProperty("ENDDATE", this.pub.getEndDate().toString());
            }
            keyData.setProperty("INSTANCEID", this.fatherPK.getInstanceId());
            if (this.fatherPK.getId() != null) {
                keyData.setProperty("FATHERID", this.fatherPK.getId());
            }
        }
        catch (SKDException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
        return keyData;
    }

    public static class TransferData {
        private final PublicationDetail publication;
        private final NodePK fatherPK;

        private TransferData(PublicationDetail publication, NodePK fatherPK) {
            this.publication = publication;
            this.fatherPK = fatherPK;
        }

        public PublicationDetail getPublicationDetail() {
            return this.publication;
        }

        public NodePK getFatherPK() {
            return this.fatherPK;
        }
    }
}

