/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.publication.model.PublicationLink;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class SeeAlsoDAO {
    private static final String SEEALSO_TABLENAME = "SB_SeeAlso_Link";

    private SeeAlsoDAO() {
    }

    public static void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)SEEALSO_TABLENAME).where("objectinstanceid = ?", new Object[]{componentInstanceId}).or("targetinstanceid = ?", new Object[]{componentInstanceId}).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLink(Connection con, PublicationPK objectPK, ResourceReference targetPK) throws SQLException {
        int newId = DBUtil.getNextId((String)SEEALSO_TABLENAME, (String)"id");
        String insertStatement = "insert into SB_SeeAlso_Link values ( ? , ? , ? , ? , ? )";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(objectPK.getId()));
            prepStmt.setString(3, objectPK.getInstanceId());
            prepStmt.setInt(4, Integer.parseInt(targetPK.getId()));
            prepStmt.setString(5, targetPK.getInstanceId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteLink(String id) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)SEEALSO_TABLENAME).where("id = ?", new Object[]{Integer.parseInt(id)}).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLinksByObjectId(Connection con, PublicationPK objectPK) throws SQLException {
        String deleteStatement = "delete from SB_SeeAlso_Link where objectId = ? AND objectInstanceId = ? ";
        PreparedStatement prepStmt = con.prepareStatement(deleteStatement);
        try {
            prepStmt.setInt(1, Integer.parseInt(objectPK.getId()));
            prepStmt.setString(2, objectPK.getInstanceId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLinksByTargetId(Connection con, ResourceReference targetPK) throws SQLException {
        String deleteStatement = "delete from SB_SeeAlso_Link where targetId = ? AND targetInstanceId = ? ";
        PreparedStatement prepStmt = con.prepareStatement(deleteStatement);
        try {
            prepStmt.setInt(1, Integer.parseInt(targetPK.getId()));
            prepStmt.setString(2, targetPK.getInstanceId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PublicationLink> getLinks(Connection con, PublicationPK pubPK) throws SQLException {
        ArrayList<PublicationLink> arrayList;
        ResultSet rs = null;
        String selectStatement = "select id, targetId, targetInstanceId from SB_SeeAlso_Link where objectId  = ? AND objectInstanceId = ? ";
        PreparedStatement prepStmt = con.prepareStatement(selectStatement);
        try {
            prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
            prepStmt.setString(2, pubPK.getInstanceId());
            rs = prepStmt.executeQuery();
            ArrayList<PublicationLink> list = new ArrayList<PublicationLink>();
            while (rs.next()) {
                list.add(SeeAlsoDAO.getLink(pubPK, rs));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PublicationLink> getReverseLinks(Connection con, PublicationPK pubPK) throws SQLException {
        ArrayList<PublicationLink> arrayList;
        ResultSet rs = null;
        String selectStatement = "select id, objectId, objectInstanceId  from SB_SeeAlso_Link where targetId   = ? AND targetInstanceId = ? ";
        PreparedStatement prepStmt = con.prepareStatement(selectStatement);
        try {
            prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
            prepStmt.setString(2, pubPK.getInstanceId());
            rs = prepStmt.executeQuery();
            ArrayList<PublicationLink> list = new ArrayList<PublicationLink>();
            while (rs.next()) {
                PublicationLink link = SeeAlsoDAO.getLink(pubPK, rs);
                link.setReverse(true);
                list.add(link);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    private static PublicationLink getLink(PublicationPK pubPK, ResultSet rs) throws SQLException {
        String id = Integer.toString(rs.getInt(1));
        String targetId = Integer.toString(rs.getInt(2));
        String targetInstanceId = rs.getString(3);
        ResourceReference targetPK = new ResourceReference(targetId, targetInstanceId);
        return new PublicationLink(id, pubPK, targetPK);
    }
}

