/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.CollectionUtil;

public class PublicationCriteria {
    private boolean emptyResultIfNoComponentInstances = true;
    private final List<String> componentInstanceIds = new ArrayList<String>();
    private final Set<String> statuses = new HashSet<String>();
    private final Set<Integer> includedNodeIds = new HashSet<Integer>();
    private final Set<Integer> excludedNodeIds = new HashSet<Integer>();
    private final List<QUERY_ORDER_BY> orderByList = new ArrayList<QUERY_ORDER_BY>();
    private boolean mustHaveAtLeastOneNodeFather = false;
    private boolean takingAliasesIntoAccount = false;
    private OffsetDateTime visibilityDate = null;
    private OffsetDateTime invisibilityDate = null;
    private OffsetDateTime lastUpdatedSince = null;
    private PaginationPage pagination;

    private PublicationCriteria() {
    }

    public static PublicationCriteria onAllComponentInstances() {
        PublicationCriteria criteria = new PublicationCriteria();
        criteria.emptyResultIfNoComponentInstances = false;
        return criteria;
    }

    public static PublicationCriteria onComponentInstanceIds(String ... componentInstanceIds) {
        return PublicationCriteria.onComponentInstanceIds(Stream.of(componentInstanceIds).collect(Collectors.toList()));
    }

    public static PublicationCriteria onComponentInstanceIds(Collection<String> componentInstanceIds) {
        PublicationCriteria criteria = new PublicationCriteria();
        criteria.componentInstanceIds.addAll(componentInstanceIds);
        return criteria;
    }

    public static PublicationCriteria excludingTrashNodeOnComponentInstanceIds(String ... componentInstanceIds) {
        return PublicationCriteria.onComponentInstanceIds(componentInstanceIds).excludingNodes("1");
    }

    public static PublicationCriteria excludingTrashNodeOnComponentInstanceIds(Collection<String> componentInstanceIds) {
        return PublicationCriteria.onComponentInstanceIds(componentInstanceIds).excludingNodes("1");
    }

    public PublicationCriteria ofStatus(String ... statuses) {
        this.statuses.addAll(Stream.of(statuses).collect(Collectors.toList()));
        return this;
    }

    public PublicationCriteria mustHaveAtLeastOneNodeFather() {
        this.mustHaveAtLeastOneNodeFather = true;
        return this;
    }

    public PublicationCriteria takingAliasesIntoAccount() {
        this.takingAliasesIntoAccount = true;
        return this;
    }

    public PublicationCriteria onNodes(String ... nodeIds) {
        return this.onNodes(Stream.of(nodeIds).collect(Collectors.toList()));
    }

    public PublicationCriteria onNodes(Collection<String> nodeIds) {
        this.includedNodeIds.addAll(nodeIds.stream().map(Integer::parseInt).collect(Collectors.toList()));
        return this;
    }

    public PublicationCriteria excludingNodes(String ... nodeIds) {
        return this.excludingNodes(Stream.of(nodeIds).collect(Collectors.toList()));
    }

    public PublicationCriteria excludingNodes(Collection<String> nodeIds) {
        this.excludedNodeIds.addAll(nodeIds.stream().map(Integer::parseInt).collect(Collectors.toList()));
        return this;
    }

    public PublicationCriteria visibleAt(OffsetDateTime visibilityDate) {
        this.visibilityDate = visibilityDate;
        return this;
    }

    public PublicationCriteria nonVisibleAt(OffsetDateTime invisibilityDate) {
        this.invisibilityDate = invisibilityDate;
        return this;
    }

    public PublicationCriteria lastUpdatedSince(OffsetDateTime lastUpdatedSince) {
        this.lastUpdatedSince = lastUpdatedSince;
        return this;
    }

    public PublicationCriteria limitTo(int limit) {
        this.paginateBy(limit > 0 ? new PaginationPage(1, limit).originalSizeIsNotRequired() : null);
        return this;
    }

    public PublicationCriteria paginateBy(PaginationPage pagination) {
        this.pagination = pagination;
        return this;
    }

    public PublicationCriteria orderByDescendingBeginDate() {
        return this.orderBy(QUERY_ORDER_BY.BEGIN_VISIBILITY_DATE_DESC, QUERY_ORDER_BY.CREATION_DATE_DESC);
    }

    public PublicationCriteria orderByDescendingLastUpdateDate() {
        return this.orderBy(QUERY_ORDER_BY.LAST_UPDATE_DATE_DESC, QUERY_ORDER_BY.CREATION_DATE_DESC);
    }

    public PublicationCriteria orderBy(QUERY_ORDER_BY ... orderBies) {
        CollectionUtil.addAllIgnoreNull(this.orderByList, (Object[])orderBies);
        return this;
    }

    boolean emptyResultWhenNoFilteringOnComponentInstances() {
        return this.emptyResultIfNoComponentInstances && this.componentInstanceIds.isEmpty();
    }

    boolean mustJoinOnNodeFatherTable() {
        return this.takingAliasesIntoAccount || this.mustHaveAtLeastOneNodeFather || !this.includedNodeIds.isEmpty() || !this.excludedNodeIds.isEmpty();
    }

    public boolean isAliasesTakenIntoAccount() {
        return this.takingAliasesIntoAccount;
    }

    public List<String> getComponentInstanceIds() {
        return this.componentInstanceIds;
    }

    Set<String> getStatuses() {
        return this.statuses;
    }

    Set<Integer> getIncludedNodeIds() {
        return this.includedNodeIds;
    }

    OffsetDateTime getVisibilityDate() {
        return this.visibilityDate;
    }

    OffsetDateTime getInvisibilityDate() {
        return this.invisibilityDate;
    }

    OffsetDateTime getLastUpdatedSince() {
        return this.lastUpdatedSince;
    }

    Set<Integer> getExcludedNodeIds() {
        return this.excludedNodeIds;
    }

    public PaginationPage getPagination() {
        return this.pagination;
    }

    List<QUERY_ORDER_BY> getOrderByList() {
        return this.orderByList;
    }

    public String toString() {
        return new StringJoiner(", ", PublicationCriteria.class.getSimpleName() + "[", "]").add("emptyResultIfNoComponentInstances=" + this.emptyResultIfNoComponentInstances).add("componentInstanceIds=" + String.valueOf(this.componentInstanceIds)).add("statuses=" + String.valueOf(this.statuses)).add("includedNodeIds=" + String.valueOf(this.includedNodeIds)).add("excludedNodeIds=" + String.valueOf(this.excludedNodeIds)).add("orderByList=" + String.valueOf(this.orderByList)).add("visibilityDate=" + String.valueOf(this.visibilityDate)).add("invisibilityDate=" + String.valueOf(this.invisibilityDate)).add("lastUpdatedSince=" + String.valueOf(this.lastUpdatedSince)).add("pagination=" + String.valueOf(this.pagination)).toString();
    }

    public static enum QUERY_ORDER_BY {
        BEGIN_VISIBILITY_DATE_ASC("maxBeginOrUpdateDate", true, true),
        BEGIN_VISIBILITY_DATE_DESC("maxBeginOrUpdateDate", false, true),
        LAST_UPDATE_DATE_ASC("pubUpdateDate", true, false),
        LAST_UPDATE_DATE_DESC("pubUpdateDate", false, false),
        CREATION_DATE_ASC("pubId", true, false),
        CREATION_DATE_DESC("pubId", false, false);

        private final String propertyName;
        private final boolean asc;
        private final boolean complex;

        private QUERY_ORDER_BY(String propertyName, boolean asc, boolean complex) {
            this.propertyName = propertyName;
            this.asc = asc;
            this.complex = complex;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public boolean isComplex() {
            return this.complex;
        }
    }
}

