/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.converter.openoffice;

import java.io.File;
import javax.inject.Named;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.ToPDFConverter;
import org.silverpeas.core.contribution.converter.openoffice.OpenOfficeConverter;
import org.silverpeas.core.util.MimeTypes;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Named(value="toPDFConverter")
public class OpenOfficeToPDFConverter
extends OpenOfficeConverter
implements ToPDFConverter {
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.converter.openoffice");
    private MimeTypes.MimeTypeRegistry compatibleDocumentMimeTypes = new MimeTypes.MimeTypeRegistry(() -> this.settings.getString("openoffice.compatible.document.extensions", ""), MimeTypes.OPEN_OFFICE_MIME_TYPES);

    @Override
    public DocumentFormat[] getSupportedFormats() {
        return new DocumentFormat[]{DocumentFormat.pdf};
    }

    @Override
    public boolean isDocumentSupported(File document) {
        return this.isDocumentSupported(document.getPath());
    }

    @Override
    public boolean isDocumentSupported(String fileName) {
        String mimeType = FileUtil.getMimeType(fileName);
        return this.compatibleDocumentMimeTypes.contains(mimeType);
    }
}

