/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.contentcontainer.content;

import java.sql.Connection;
import javax.inject.Inject;
import org.silverpeas.core.contribution.ContributionDeletion;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverpeasContentDeleter
implements ContributionDeletion {
    @Inject
    private ContentManagementEngine contentMgtEngine;

    public void delete(Contribution contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        try {
            int contentId = this.contentMgtEngine.getSilverContentId(contributionId.getLocalId(), contributionId.getComponentInstanceId());
            if (contentId != -1) {
                Transaction.performInOne(() -> {
                    try (Connection connection = DBUtil.openConnection();){
                        this.contentMgtEngine.removeSilverContent(connection, contentId);
                    }
                    return null;
                });
            }
        }
        catch (ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }
}

