/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;

public abstract class TextField
extends AbstractField {
    private static final long serialVersionUID = 983277921021971664L;
    public static final String TYPE = "text";
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_TYPE_INT = "int";
    public static final String CONTENT_TYPE_FLOAT = "float";
    public static final String PARAM_MAXLENGTH = "maxLength";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public abstract boolean isReadOnly();

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    @Override
    public String getValue(String language) {
        return this.getStringValue();
    }

    @Override
    public void setValue(String value) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public void setValue(String value, String language) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public boolean acceptValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return !this.isReadOnly();
    }

    @Override
    public Object getObjectValue() {
        return this.getStringValue();
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else {
            if (value != null) {
                throw new FormException("Incorrect field value type. Expected a text", new String[0]);
            }
            this.setNull();
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof String && !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getStringValue() == null || this.getStringValue().trim().isEmpty();
    }

    @Override
    public void setNull() throws FormException {
        this.setStringValue(null);
    }

    public boolean equals(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof TextField) {
            String t = ((TextField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.equalsIgnoreCase(t);
        }
        if (o instanceof Field) {
            String t = ((Field)o).getValue("");
            if (t == null) {
                t = "";
            }
            return s.equalsIgnoreCase(t);
        }
        return false;
    }

    @Override
    public int compareTo(Field o) {
        String t;
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if ((t = o instanceof TextField ? o.getStringValue() : o.getValue("")) == null) {
            t = "";
        }
        return s.compareTo(t);
    }

    public int hashCode() {
        String s = this.getStringValue();
        return s.toLowerCase().hashCode();
    }
}

