/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFileFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.VideoPlayer;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.util.StringUtil;

public class VideoFieldDisplayer
extends AbstractFileFieldDisplayer {
    public static final String DEFAULT_WIDTH = "425";
    public static final String DEFAULT_HEIGHT = "300";
    public static final boolean DEFAULT_AUTOPLAY = true;
    public static final String PARAMETER_WIDTH = "width";
    public static final String PARAMETER_HEIGHT = "height";
    public static final String PARAMETER_AUTOPLAY = "autoplay";
    private static final int DISPLAYED_HTML_OBJECTS = 2;

    @Override
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String attachmentId = field.getValue();
        if (!StringUtil.isDefined((String)attachmentId)) {
            attachmentId = "";
        }
        if (!template.isHidden()) {
            ElementContainer xhtmlContainer = new ElementContainer();
            VideoPlayer videoPlayer = new VideoPlayer();
            videoPlayer.init((ConcreteElement)xhtmlContainer);
            if (template.isReadOnly()) {
                this.displayVideo(videoPlayer, attachmentId, template, xhtmlContainer, pagesContext);
            } else if (!template.isDisabled()) {
                this.displayVideoFormInput(videoPlayer, attachmentId, template, xhtmlContainer, pagesContext, field);
            }
            out.println(xhtmlContainer);
        }
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    private String computeVideoURL(String attachmentId, PagesContext pageContext) {
        Object videoURL = "";
        if (StringUtil.isDefined((String)attachmentId)) {
            if (attachmentId.startsWith("/")) {
                videoURL = attachmentId;
            } else {
                SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId, pageContext.getComponentId()), pageContext.getContentLanguage());
                if (attachment != null) {
                    String webContext = FileServerUtils.getApplicationContext();
                    videoURL = webContext + attachment.getAttachmentURL();
                    if (pageContext.isSharingContext()) {
                        videoURL = pageContext.getSharingContext().getSharedUriOf(attachment).toString();
                    }
                }
            }
        }
        return videoURL;
    }

    private void displayVideo(VideoPlayer videoPlayer, String attachmentId, FieldTemplate template, ElementContainer xhtmlContainer, PagesContext pagesContext) {
        String videoURL = this.computeVideoURL(attachmentId, pagesContext);
        if (StringUtil.isDefined((String)videoURL)) {
            Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
            this.initVideoPlayer(videoPlayer, videoURL, parameters);
            videoPlayer.renderIn((ConcreteElement)xhtmlContainer);
        }
    }

    private void displayVideoFormInput(VideoPlayer videoPlayer, String attachmentId, FieldTemplate template, ElementContainer xhtmlContainer, PagesContext pagesContext, FileField field) {
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        String language = pagesContext.getLanguage();
        String deletionIcon = Util.getIcon("delete");
        String deletionLab = Util.getString("removeFile", language);
        String videoURL = this.computeVideoURL(attachmentId, pagesContext);
        AbstractFileFieldDisplayer.Operation defaultOperation = AbstractFileFieldDisplayer.Operation.ADD;
        if (!videoURL.isEmpty()) {
            defaultOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
            Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
            parameters.remove(PARAMETER_WIDTH);
            parameters.remove(PARAMETER_HEIGHT);
            this.initVideoPlayer(videoPlayer, videoURL, parameters);
            img deletionImage = new img();
            deletionImage.setAlt(deletionLab).setSrc(deletionIcon).setWidth(15).setHeight(15).setAlt(deletionLab).setTitle(deletionLab);
            a removeLink = new a();
            removeLink.setHref("#").addElement((Element)deletionImage).setOnClick("javascript: document.getElementById('" + fieldName + "Video').style.display='none'; document." + pagesContext.getFormName() + "." + fieldName + "Operation.value='" + AbstractFileFieldDisplayer.Operation.DELETION.name() + "';return false;");
            div videoDiv = new div();
            videoDiv.setID(fieldName + "Video");
            videoDiv.setClass("video");
            videoPlayer.renderIn((ConcreteElement)videoDiv);
            videoDiv.addElement("&nbsp;");
            videoDiv.addElement((Element)removeLink);
            xhtmlContainer.addElement((Element)videoDiv);
        }
        input fileInput = new input();
        fileInput.setID(fieldName);
        fileInput.setType("file");
        fileInput.setSize(50);
        fileInput.setName(fieldName);
        input attachmentInput = new input();
        attachmentInput.setType("hidden").setName(fieldName + "$$id").setValue(attachmentId).setID(fieldName + "_id");
        input operationInput = new input();
        operationInput.setType("hidden").setName(fieldName + "Operation").setValue(defaultOperation.name()).setID(fieldName + "Operation");
        div selectionDiv = new div();
        selectionDiv.setID(fieldName + "Selection");
        selectionDiv.setClass("videoFieldSelection");
        selectionDiv.addElement((Element)fileInput);
        selectionDiv.addElement((Element)attachmentInput);
        selectionDiv.addElement((Element)operationInput);
        if (template.isMandatory() && pagesContext.useMandatory()) {
            selectionDiv.addElement(Util.getMandatorySnippet());
        }
        xhtmlContainer.addElement((Element)selectionDiv);
    }

    private void initVideoPlayer(VideoPlayer videoPlayer, String videoURL, Map<String, String> parameters) {
        int width = Integer.parseInt(parameters.getOrDefault(PARAMETER_WIDTH, DEFAULT_WIDTH));
        int height = Integer.parseInt(parameters.getOrDefault(PARAMETER_HEIGHT, DEFAULT_HEIGHT));
        boolean autoplay = parameters.containsKey(PARAMETER_AUTOPLAY) && Boolean.parseBoolean(parameters.get(PARAMETER_AUTOPLAY));
        videoPlayer.setVideoURL(videoURL);
        videoPlayer.setAutoplay(autoplay);
        videoPlayer.setWidth(width);
        videoPlayer.setHeight(height);
    }
}

