/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FieldValue;
import org.silverpeas.core.contribution.content.form.FieldValuesTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class TextDisplayer
extends AbstractFieldDisplayer<Field> {
    private static final String FONT_SIZE = "fontSize";
    private static final String FONT_COLOR = "fontColor";
    private static final String FONT_FACE = "fontFace";

    public String[] getManagedTypes() {
        return new String[]{"text", "date"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
    }

    @Override
    public void display(PrintWriter out, Field field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        StringBuilder html2 = new StringBuilder(10000);
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        String value = this.getFieldValue(template, parameters, field, pagesContext);
        String cssClass = TextDisplayer.getCssClass(parameters);
        if (StringUtil.isDefined((String)cssClass)) {
            html2.append("<span ").append(cssClass).append(">");
        }
        if (parameters.containsKey(FONT_SIZE) || parameters.containsKey(FONT_COLOR) || parameters.containsKey(FONT_FACE)) {
            html2.append("<font");
        }
        String size = "";
        if (parameters.containsKey(FONT_SIZE)) {
            size = parameters.get(FONT_SIZE);
            html2.append(" size=\"").append(size).append("\"");
        }
        String color = "";
        if (parameters.containsKey(FONT_COLOR)) {
            color = parameters.get(FONT_COLOR);
            html2.append(" color=\"").append(color).append("\"");
        }
        String face = "";
        if (parameters.containsKey(FONT_FACE)) {
            face = parameters.get(FONT_FACE);
            html2.append(" face=\"").append(face).append("\"");
        }
        if (StringUtil.isDefined((String)size) || StringUtil.isDefined((String)color) || StringUtil.isDefined((String)face)) {
            html2.append(">");
        }
        String bold = "";
        if (parameters.containsKey("bold") && "true".equals(bold = parameters.get("bold"))) {
            html2.append("<b>");
        }
        html2.append(value);
        if (StringUtil.isDefined((String)bold)) {
            html2.append("</b>");
        }
        if (StringUtil.isDefined((String)size) || StringUtil.isDefined((String)color) || StringUtil.isDefined((String)face)) {
            html2.append("</font>");
        }
        if (StringUtil.isDefined((String)cssClass)) {
            html2.append("</span>");
        }
        out.print(html2);
    }

    private static String getCssClass(Map<String, String> parameters) {
        Object cssClass = null;
        if (parameters.containsKey("class") && (cssClass = parameters.get("class")) != null) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        return cssClass;
    }

    private String getFieldValue(FieldTemplate template, Map<String, String> parameters, Field field, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String value = "";
        if (!field.isNull()) {
            value = field.getTypeName().equals("date") ? this.getDateValue(field, pagesContext) : (field.getTypeName().equals("file") ? TextDisplayer.getFilenameValue(field, pagesContext) : (field.getTypeName().equals("publicationsPicker") ? WebEncodeHelper.convertBlanksForHtml((String)field.getValue()) : WebEncodeHelper.convertBlanksForHtml((String)Encode.forHtml((String)field.getValue(language)))));
        }
        if (parameters.containsKey("values") || parameters.containsKey("keys")) {
            FieldValuesTemplate valuesTemplate = template.getFieldValuesTemplate(language);
            FieldValue emptyValue = FieldValue.emptyFor(language);
            StringBuilder newValue = new StringBuilder();
            if (StringUtil.isDefined((String)value)) {
                if (value.contains("##")) {
                    TextDisplayer.buildValuesList(value, valuesTemplate, newValue);
                } else {
                    newValue.append(valuesTemplate.get(value).orElse(emptyValue).getLabel());
                }
            }
            value = newValue.toString();
        }
        return value;
    }

    private static void buildValuesList(String value, FieldValuesTemplate valuesTemplate, StringBuilder valuesList) {
        String values = Parameter.decode(value).stream().map(v -> valuesTemplate.get((String)v).orElseThrow(() -> new NotFoundException("No such value for " + v))).map(FieldValue::getLabel).collect(Collectors.joining(", "));
        valuesList.append(values);
    }

    private static String getFilenameValue(Field field, PagesContext pagesContext) {
        SimpleDocument doc = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(field.getValue(), pagesContext.getComponentId()), null);
        if (doc != null) {
            return doc.getFilename();
        }
        return "";
    }

    private String getDateValue(Field field, PagesContext pagesContext) {
        try {
            return DateUtil.getOutputDate((String)field.getValue(), (String)pagesContext.getLanguage());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Incorrect type for value " + field.getValue(), (Throwable)e);
            return "";
        }
    }

    @Override
    public List<String> update(String newValue, Field field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return false;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 0;
    }
}

