/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.ddwe.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.ddwe.DragAndDropWbeFile;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.exception.NotSupportedException;
import org.silverpeas.kernel.util.StringUtil;

public class DragAndDropWebEditorStore
implements SilverpeasResource,
Serializable,
Securable {
    private static final long serialVersionUID = 996933763895325970L;
    private static final String FILE_PREFIX = "ddwecontent_";
    private final ContributionIdentifier contributionId;
    private final transient MemoizedSupplier<Contribution> foreignContribution = new MemoizedSupplier(() -> ApplicationService.getInstance((String)this.getContributionId().getComponentInstanceId()).getContributionById(this.getContributionId()).orElse(null));
    private File file;

    public DragAndDropWebEditorStore(ContributionIdentifier contribution) {
        this.contributionId = contribution;
    }

    public File getFile() {
        if (this.file == null) {
            Path filePath = Paths.get(this.getDirectoryPath().toString(), FILE_PREFIX + this.getContributionId().getLocalId() + ".xml");
            this.file = new File(this.getContributionId().getComponentInstanceId(), filePath.toString());
        }
        return this.file;
    }

    public void save() {
        this.getFile().save();
    }

    public boolean delete() {
        WbeHostManager.get().revokeFile((WbeFile)new DragAndDropWbeFile(this));
        return this.getFile().delete();
    }

    public String getName() {
        return this.getForeignContribution().map(Contribution::getName).orElse("");
    }

    public String getDescription() {
        return "";
    }

    public ContributionIdentifier getIdentifier() {
        return this.getContributionId();
    }

    public ContributionIdentifier getContributionId() {
        return this.contributionId;
    }

    public Date getCreationDate() {
        return this.getFile().getContainer().getContent().map(Content::getMetadata).map(Content.Metadata::getCreated).map(TemporalConverter::asDate).orElse(null);
    }

    public Date getLastUpdateDate() {
        return this.getFile().getContainer().getContent().map(Content::getMetadata).map(Content.Metadata::getLastUpdated).map(TemporalConverter::asDate).orElse(null);
    }

    public User getCreator() {
        return this.getFile().getContainer().getContent().map(Content::getMetadata).map(Content.Metadata::getCreatedBy).map(User::getById).orElse(null);
    }

    public User getLastUpdater() {
        return this.getFile().getContainer().getContent().map(Content::getMetadata).map(Content.Metadata::getLastUpdatedBy).map(User::getById).orElse(null);
    }

    public Path getDirectoryPath() {
        return Paths.get(FileRepositoryManager.getAbsolutePath(this.getContributionId().getComponentInstanceId()), "ddwe", this.getContributionId().getType());
    }

    private Optional<Contribution> getForeignContribution() {
        return Optional.ofNullable(this.getContributionId()).map(i -> (Contribution)this.foreignContribution.get());
    }

    public boolean canBeAccessedBy(User user) {
        return ComponentAccessControl.get().isUserAuthorized(user.getId(), (Object)this.getContributionId().getComponentInstanceId());
    }

    public boolean canBeModifiedBy(User user) {
        return ComponentAccessControl.get().isUserAuthorized(user.getId(), (Object)this.getContributionId().getComponentInstanceId(), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}));
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Content
    implements Serializable {
        private static final long serialVersionUID = -5418311140838509632L;
        @XmlTransient
        private final Metadata metadata = new Metadata(this);
        @XmlAttribute(required=true)
        private String createdBy;
        @XmlAttribute(required=true)
        private String created;
        @XmlAttribute(required=true)
        private String lastUpdatedBy;
        @XmlAttribute(required=true)
        private String lastUpdated;
        @XmlValue
        private String value;

        public Metadata getMetadata() {
            return this.metadata;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static class Metadata
        implements Serializable {
            private static final long serialVersionUID = 5799777732297383841L;
            private final Content content;

            public Metadata(Content content) {
                this.content = content;
            }

            public String getCreatedBy() {
                return this.content.createdBy;
            }

            public void setCreatedBy(String createdBy) {
                this.content.createdBy = createdBy;
            }

            public ZonedDateTime getCreated() {
                return ZonedDateTime.parse(this.content.created);
            }

            public void setCreated(ZonedDateTime created) {
                this.content.created = created.toString();
            }

            public String getLastUpdatedBy() {
                return this.content.lastUpdatedBy;
            }

            public void setLastUpdatedBy(String lastUpdatedBy) {
                this.content.lastUpdatedBy = lastUpdatedBy;
            }

            public ZonedDateTime getLastUpdated() {
                return ZonedDateTime.parse(this.content.lastUpdated);
            }

            public void setLastUpdated(ZonedDateTime lastUpdated) {
                this.content.lastUpdated = lastUpdated.toString();
            }
        }
    }

    @XmlRootElement(name="ddwe-container")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Container
    implements Serializable {
        private static final long serialVersionUID = 4451531724957681559L;
        @XmlElement(name="tmp-content")
        private Content tmpContent;
        @XmlElement(name="content")
        private Content content;

        protected static Container loadFrom(InputStream in) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Container.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                return (Container)unmarshaller.unmarshal(in);
            }
            catch (JAXBException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
            }
        }

        protected static void writeIn(Container content, OutputStream out) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Container.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)content, out);
            }
            catch (JAXBException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
            }
        }

        public Optional<Content> getTmpContent() {
            return Optional.ofNullable(this.tmpContent);
        }

        public Content getOrCreateTmpContent() {
            if (this.tmpContent == null) {
                this.tmpContent = new Content();
            }
            return this.tmpContent;
        }

        public Optional<Content> getContent() {
            return Optional.ofNullable(this.content);
        }

        public Content getOrCreateContent() {
            if (this.content == null) {
                this.content = new Content();
            }
            return this.content;
        }
    }

    public static class File
    extends SilverpeasFile {
        public static final String MIME_TYPE = "text/ddwe";
        private static final long serialVersionUID = -3539881144930179164L;
        private Container container;
        private long lastModificationDateStamp = 0L;

        protected File(String componentId, String path) {
            super(componentId, path, MIME_TYPE);
        }

        public Container getContainer() {
            block10: {
                if (this.container == null || this.lastModificationDateStamp != this.lastModified()) {
                    if (this.exists()) {
                        this.lastModificationDateStamp = this.lastModified();
                        try (InputStream in = this.inputStream();){
                            this.container = Container.loadFrom(in);
                            break block10;
                        }
                        catch (IOException e) {
                            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.container = new Container();
                }
            }
            return this.container;
        }

        protected void save() {
            User currentUser = Optional.ofNullable(User.getCurrentRequester()).orElse(User.getSystemUser());
            ZonedDateTime now = ZonedDateTime.now();
            Stream.of(this.getContainer().getTmpContent(), this.getContainer().getContent()).flatMap(Optional::stream).forEach(c -> {
                Content.Metadata metadata = c.getMetadata();
                if (StringUtil.isNotDefined((String)metadata.getCreatedBy())) {
                    metadata.setCreated(now);
                    metadata.setCreatedBy(currentUser.getId());
                }
                metadata.setLastUpdated(now);
                metadata.setLastUpdatedBy(currentUser.getId());
            });
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Container.writeIn(this.getContainer(), out);
                try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                    super.writeFrom(in);
                }
            }
            catch (IOException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void writeFrom(InputStream stream) {
            throw new NotSupportedException("This low level method is not supported, please use DragAndDropWebEditorContent#save() method");
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

