/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.webdav.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.webdav.WebdavRepository;
import org.silverpeas.core.contribution.attachment.webdav.WebdavService;
import org.silverpeas.core.contribution.attachment.webdav.impl.WebdavContentDescriptor;
import org.silverpeas.core.jcr.JCRSession;

@Service
public class WebDavDocumentService
implements WebdavService {
    private static final String DOCUMENT_NOT_FOUND = "Document not found";
    private static final String UNLOCK_FAILURE = "Unlock failure";
    @Inject
    private WebdavRepository webdavRepository;

    @Override
    public void updateDocumentContent(SimpleDocument document) {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.webdavRepository.updateAttachmentBinaryContent((Session)session, document);
            session.save();
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException("Fail to update the document content", ex);
        }
    }

    @Override
    public String getContentEditionLanguage(SimpleDocument document) {
        String string;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                string = this.webdavRepository.getContentEditionLanguage((Session)session, document);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(DOCUMENT_NOT_FOUND, ex);
                }
            }
            session.close();
        }
        return string;
    }

    @Override
    public long getContentEditionSize(SimpleDocument document) {
        long l;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                l = this.webdavRepository.getContentEditionSize((Session)session, document);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(DOCUMENT_NOT_FOUND, ex);
                }
            }
            session.close();
        }
        return l;
    }

    @Override
    public Optional<WebdavContentDescriptor> getDescriptor(SimpleDocument document) {
        Optional<WebdavContentDescriptor> optional;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                optional = this.webdavRepository.getDescriptor((Session)session, document);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(DOCUMENT_NOT_FOUND, ex);
                }
            }
            session.close();
        }
        return optional;
    }

    @Override
    public void updateContentFrom(SimpleDocument document, InputStream input2) throws IOException {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.webdavRepository.updateContentFrom((Session)session, document, input2);
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(DOCUMENT_NOT_FOUND, ex);
        }
    }

    @Override
    public void loadContentInto(SimpleDocument document, OutputStream output) throws IOException {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.webdavRepository.loadContentInto((Session)session, document, output);
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(DOCUMENT_NOT_FOUND, ex);
        }
    }

    @Override
    public void unlockOfficeEditor(SimpleDocument document) {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.webdavRepository.unlockLockedNode((Session)session, document);
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(UNLOCK_FAILURE, ex);
        }
    }
}

