/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.FileDataSource;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.LinkUrlDataSource;
import org.silverpeas.core.contribution.content.LinkUrlDataSourceScanner;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.util.StringDataExtractor;

@Service
public class SimpleDocumentUrlToDataSourceScanner
implements LinkUrlDataSourceScanner {
    private static final List<Pattern> ATTACHMENT_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)=\"([^\"]*/attachmentId/[a-z\\-0-9]+/[^\"]+)"), Pattern.compile("(?i)=\"([^\"]*/File/[a-z\\-0-9]+[^\"]*)"));

    @Override
    public List<LinkUrlDataSource> scanHtml(String htmlContent) {
        ArrayList<LinkUrlDataSource> result = new ArrayList<LinkUrlDataSource>();
        StringDataExtractor.from(htmlContent).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_LINK_PATTERNS, 1)).extract().forEach(l -> {
            SilverpeasFile attachmentFile = SilverpeasFileProvider.getFile(l);
            if (attachmentFile.exists()) {
                result.add(new LinkUrlDataSource((String)l, () -> new FileDataSource((File)attachmentFile)));
            }
        });
        return result;
    }
}

